package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.status.KafkaRebalanceStatus;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluent;
import io.strimzi.api.kafka.model.status.KafkaRebalanceStatusBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaRebalanceFluent<A extends KafkaRebalanceFluent<A>> extends CustomResourceFluent<KafkaRebalanceSpec,KafkaRebalanceStatus,A>{
  public KafkaRebalanceFluent() {
  }
  public KafkaRebalanceFluent(KafkaRebalance instance) {
    instance = (instance != null ? instance : new KafkaRebalance());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private KafkaRebalanceSpecBuilder spec;
  private KafkaRebalanceStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public KafkaRebalanceSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(KafkaRebalanceSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new KafkaRebalanceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public boolean hasSpec() {
    return this.spec != null;
  }
  public SpecNested<A> withNewSpec() {
    return new SpecNested(null);
  }
  public SpecNested<A> withNewSpecLike(KafkaRebalanceSpec item) {
    return new SpecNested(item);
  }
  public SpecNested<A> editSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(null));
  }
  public SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(new KafkaRebalanceSpecBuilder().build()));
  }
  public SpecNested<A> editOrNewSpecLike(KafkaRebalanceSpec item) {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(item));
  }
  public KafkaRebalanceStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(KafkaRebalanceStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new KafkaRebalanceStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public boolean hasStatus() {
    return this.status != null;
  }
  public StatusNested<A> withNewStatus() {
    return new StatusNested(null);
  }
  public StatusNested<A> withNewStatusLike(KafkaRebalanceStatus item) {
    return new StatusNested(item);
  }
  public StatusNested<A> editStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(null));
  }
  public StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(new KafkaRebalanceStatusBuilder().build()));
  }
  public StatusNested<A> editOrNewStatusLike(KafkaRebalanceStatus item) {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaRebalanceFluent that = (KafkaRebalanceFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  public class SpecNested<N> extends KafkaRebalanceSpecFluent<SpecNested<N>> implements Nested<N>{
    SpecNested(KafkaRebalanceSpec item) {
      this.builder = new KafkaRebalanceSpecBuilder(this, item);
    }
    KafkaRebalanceSpecBuilder builder;
    public N and() {
      return (N) KafkaRebalanceFluent.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  public class StatusNested<N> extends KafkaRebalanceStatusFluent<StatusNested<N>> implements Nested<N>{
    StatusNested(KafkaRebalanceStatus item) {
      this.builder = new KafkaRebalanceStatusBuilder(this, item);
    }
    KafkaRebalanceStatusBuilder builder;
    public N and() {
      return (N) KafkaRebalanceFluent.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}