package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaSpecBuilder extends KafkaSpecFluent<KafkaSpecBuilder> implements VisitableBuilder<KafkaSpec,KafkaSpecBuilder>{
  public KafkaSpecBuilder() {
    this(false);
  }
  public KafkaSpecBuilder(Boolean validationEnabled) {
    this(new KafkaSpec(), validationEnabled);
  }
  public KafkaSpecBuilder(KafkaSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaSpecBuilder(KafkaSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaSpec(), validationEnabled);
  }
  public KafkaSpecBuilder(KafkaSpecFluent<?> fluent,KafkaSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaSpecBuilder(KafkaSpecFluent<?> fluent,KafkaSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaSpec());

    if (instance != null) {
      fluent.withKafka(instance.getKafka());
      fluent.withZookeeper(instance.getZookeeper());
      fluent.withEntityOperator(instance.getEntityOperator());
      fluent.withClusterCa(instance.getClusterCa());
      fluent.withJmxTrans(instance.getJmxTrans());
      fluent.withKafkaExporter(instance.getKafkaExporter());
      fluent.withCruiseControl(instance.getCruiseControl());
      fluent.withClientsCa(instance.getClientsCa());
      fluent.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaSpecBuilder(KafkaSpec instance) {
    this(instance,false);
  }
  public KafkaSpecBuilder(KafkaSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaSpec());

    if (instance != null) {
      this.withKafka(instance.getKafka());
      this.withZookeeper(instance.getZookeeper());
      this.withEntityOperator(instance.getEntityOperator());
      this.withClusterCa(instance.getClusterCa());
      this.withJmxTrans(instance.getJmxTrans());
      this.withKafkaExporter(instance.getKafkaExporter());
      this.withCruiseControl(instance.getCruiseControl());
      this.withClientsCa(instance.getClientsCa());
      this.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaSpec build() {
    KafkaSpec buildable = new KafkaSpec();
    buildable.setKafka(fluent.buildKafka());
    buildable.setZookeeper(fluent.buildZookeeper());
    buildable.setEntityOperator(fluent.buildEntityOperator());
    buildable.setClusterCa(fluent.buildClusterCa());
    buildable.setJmxTrans(fluent.buildJmxTrans());
    buildable.setKafkaExporter(fluent.buildKafkaExporter());
    buildable.setCruiseControl(fluent.buildCruiseControl());
    buildable.setClientsCa(fluent.buildClientsCa());
    buildable.setMaintenanceTimeWindows(fluent.getMaintenanceTimeWindows());
    return buildable;
  }
  
}