package io.strimzi.api.kafka.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.List;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaSpecFluent<A extends KafkaSpecFluent<A>> extends SpecFluent<A>{
  public KafkaSpecFluent() {
  }
  public KafkaSpecFluent(KafkaSpec instance) {
    instance = (instance != null ? instance : new KafkaSpec());

    if (instance != null) {
      this.withKafka(instance.getKafka());
      this.withZookeeper(instance.getZookeeper());
      this.withEntityOperator(instance.getEntityOperator());
      this.withClusterCa(instance.getClusterCa());
      this.withJmxTrans(instance.getJmxTrans());
      this.withKafkaExporter(instance.getKafkaExporter());
      this.withCruiseControl(instance.getCruiseControl());
      this.withClientsCa(instance.getClientsCa());
      this.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
    }
  }
  private KafkaClusterSpecBuilder kafka;
  private ZookeeperClusterSpecBuilder zookeeper;
  private EntityOperatorSpecBuilder entityOperator;
  private CertificateAuthorityBuilder clusterCa;
  private JmxTransSpecBuilder jmxTrans;
  private KafkaExporterSpecBuilder kafkaExporter;
  private CruiseControlSpecBuilder cruiseControl;
  private CertificateAuthorityBuilder clientsCa;
  private List<String> maintenanceTimeWindows;
  public KafkaClusterSpec buildKafka() {
    return this.kafka!=null ?this.kafka.build():null;
  }
  public A withKafka(KafkaClusterSpec kafka) {
    _visitables.get("kafka").remove(this.kafka);
    if (kafka!=null){ this.kafka= new KafkaClusterSpecBuilder(kafka); _visitables.get("kafka").add(this.kafka);} else { this.kafka = null; _visitables.get("kafka").remove(this.kafka); } return (A) this;
  }
  public boolean hasKafka() {
    return this.kafka != null;
  }
  public KafkaNested<A> withNewKafka() {
    return new KafkaNested(null);
  }
  public KafkaNested<A> withNewKafkaLike(KafkaClusterSpec item) {
    return new KafkaNested(item);
  }
  public KafkaNested<A> editKafka() {
    return withNewKafkaLike(java.util.Optional.ofNullable(buildKafka()).orElse(null));
  }
  public KafkaNested<A> editOrNewKafka() {
    return withNewKafkaLike(java.util.Optional.ofNullable(buildKafka()).orElse(new KafkaClusterSpecBuilder().build()));
  }
  public KafkaNested<A> editOrNewKafkaLike(KafkaClusterSpec item) {
    return withNewKafkaLike(java.util.Optional.ofNullable(buildKafka()).orElse(item));
  }
  public ZookeeperClusterSpec buildZookeeper() {
    return this.zookeeper!=null ?this.zookeeper.build():null;
  }
  public A withZookeeper(ZookeeperClusterSpec zookeeper) {
    _visitables.get("zookeeper").remove(this.zookeeper);
    if (zookeeper!=null){ this.zookeeper= new ZookeeperClusterSpecBuilder(zookeeper); _visitables.get("zookeeper").add(this.zookeeper);} else { this.zookeeper = null; _visitables.get("zookeeper").remove(this.zookeeper); } return (A) this;
  }
  public boolean hasZookeeper() {
    return this.zookeeper != null;
  }
  public ZookeeperNested<A> withNewZookeeper() {
    return new ZookeeperNested(null);
  }
  public ZookeeperNested<A> withNewZookeeperLike(ZookeeperClusterSpec item) {
    return new ZookeeperNested(item);
  }
  public ZookeeperNested<A> editZookeeper() {
    return withNewZookeeperLike(java.util.Optional.ofNullable(buildZookeeper()).orElse(null));
  }
  public ZookeeperNested<A> editOrNewZookeeper() {
    return withNewZookeeperLike(java.util.Optional.ofNullable(buildZookeeper()).orElse(new ZookeeperClusterSpecBuilder().build()));
  }
  public ZookeeperNested<A> editOrNewZookeeperLike(ZookeeperClusterSpec item) {
    return withNewZookeeperLike(java.util.Optional.ofNullable(buildZookeeper()).orElse(item));
  }
  public EntityOperatorSpec buildEntityOperator() {
    return this.entityOperator!=null ?this.entityOperator.build():null;
  }
  public A withEntityOperator(EntityOperatorSpec entityOperator) {
    _visitables.get("entityOperator").remove(this.entityOperator);
    if (entityOperator!=null){ this.entityOperator= new EntityOperatorSpecBuilder(entityOperator); _visitables.get("entityOperator").add(this.entityOperator);} else { this.entityOperator = null; _visitables.get("entityOperator").remove(this.entityOperator); } return (A) this;
  }
  public boolean hasEntityOperator() {
    return this.entityOperator != null;
  }
  public EntityOperatorNested<A> withNewEntityOperator() {
    return new EntityOperatorNested(null);
  }
  public EntityOperatorNested<A> withNewEntityOperatorLike(EntityOperatorSpec item) {
    return new EntityOperatorNested(item);
  }
  public EntityOperatorNested<A> editEntityOperator() {
    return withNewEntityOperatorLike(java.util.Optional.ofNullable(buildEntityOperator()).orElse(null));
  }
  public EntityOperatorNested<A> editOrNewEntityOperator() {
    return withNewEntityOperatorLike(java.util.Optional.ofNullable(buildEntityOperator()).orElse(new EntityOperatorSpecBuilder().build()));
  }
  public EntityOperatorNested<A> editOrNewEntityOperatorLike(EntityOperatorSpec item) {
    return withNewEntityOperatorLike(java.util.Optional.ofNullable(buildEntityOperator()).orElse(item));
  }
  public CertificateAuthority buildClusterCa() {
    return this.clusterCa!=null ?this.clusterCa.build():null;
  }
  public A withClusterCa(CertificateAuthority clusterCa) {
    _visitables.get("clusterCa").remove(this.clusterCa);
    if (clusterCa!=null){ this.clusterCa= new CertificateAuthorityBuilder(clusterCa); _visitables.get("clusterCa").add(this.clusterCa);} else { this.clusterCa = null; _visitables.get("clusterCa").remove(this.clusterCa); } return (A) this;
  }
  public boolean hasClusterCa() {
    return this.clusterCa != null;
  }
  public ClusterCaNested<A> withNewClusterCa() {
    return new ClusterCaNested(null);
  }
  public ClusterCaNested<A> withNewClusterCaLike(CertificateAuthority item) {
    return new ClusterCaNested(item);
  }
  public ClusterCaNested<A> editClusterCa() {
    return withNewClusterCaLike(java.util.Optional.ofNullable(buildClusterCa()).orElse(null));
  }
  public ClusterCaNested<A> editOrNewClusterCa() {
    return withNewClusterCaLike(java.util.Optional.ofNullable(buildClusterCa()).orElse(new CertificateAuthorityBuilder().build()));
  }
  public ClusterCaNested<A> editOrNewClusterCaLike(CertificateAuthority item) {
    return withNewClusterCaLike(java.util.Optional.ofNullable(buildClusterCa()).orElse(item));
  }
  public JmxTransSpec buildJmxTrans() {
    return this.jmxTrans!=null ?this.jmxTrans.build():null;
  }
  public A withJmxTrans(JmxTransSpec jmxTrans) {
    _visitables.get("jmxTrans").remove(this.jmxTrans);
    if (jmxTrans!=null){ this.jmxTrans= new JmxTransSpecBuilder(jmxTrans); _visitables.get("jmxTrans").add(this.jmxTrans);} else { this.jmxTrans = null; _visitables.get("jmxTrans").remove(this.jmxTrans); } return (A) this;
  }
  public boolean hasJmxTrans() {
    return this.jmxTrans != null;
  }
  public JmxTransNested<A> withNewJmxTrans() {
    return new JmxTransNested(null);
  }
  public JmxTransNested<A> withNewJmxTransLike(JmxTransSpec item) {
    return new JmxTransNested(item);
  }
  public JmxTransNested<A> editJmxTrans() {
    return withNewJmxTransLike(java.util.Optional.ofNullable(buildJmxTrans()).orElse(null));
  }
  public JmxTransNested<A> editOrNewJmxTrans() {
    return withNewJmxTransLike(java.util.Optional.ofNullable(buildJmxTrans()).orElse(new JmxTransSpecBuilder().build()));
  }
  public JmxTransNested<A> editOrNewJmxTransLike(JmxTransSpec item) {
    return withNewJmxTransLike(java.util.Optional.ofNullable(buildJmxTrans()).orElse(item));
  }
  public KafkaExporterSpec buildKafkaExporter() {
    return this.kafkaExporter!=null ?this.kafkaExporter.build():null;
  }
  public A withKafkaExporter(KafkaExporterSpec kafkaExporter) {
    _visitables.get("kafkaExporter").remove(this.kafkaExporter);
    if (kafkaExporter!=null){ this.kafkaExporter= new KafkaExporterSpecBuilder(kafkaExporter); _visitables.get("kafkaExporter").add(this.kafkaExporter);} else { this.kafkaExporter = null; _visitables.get("kafkaExporter").remove(this.kafkaExporter); } return (A) this;
  }
  public boolean hasKafkaExporter() {
    return this.kafkaExporter != null;
  }
  public KafkaExporterNested<A> withNewKafkaExporter() {
    return new KafkaExporterNested(null);
  }
  public KafkaExporterNested<A> withNewKafkaExporterLike(KafkaExporterSpec item) {
    return new KafkaExporterNested(item);
  }
  public KafkaExporterNested<A> editKafkaExporter() {
    return withNewKafkaExporterLike(java.util.Optional.ofNullable(buildKafkaExporter()).orElse(null));
  }
  public KafkaExporterNested<A> editOrNewKafkaExporter() {
    return withNewKafkaExporterLike(java.util.Optional.ofNullable(buildKafkaExporter()).orElse(new KafkaExporterSpecBuilder().build()));
  }
  public KafkaExporterNested<A> editOrNewKafkaExporterLike(KafkaExporterSpec item) {
    return withNewKafkaExporterLike(java.util.Optional.ofNullable(buildKafkaExporter()).orElse(item));
  }
  public CruiseControlSpec buildCruiseControl() {
    return this.cruiseControl!=null ?this.cruiseControl.build():null;
  }
  public A withCruiseControl(CruiseControlSpec cruiseControl) {
    _visitables.get("cruiseControl").remove(this.cruiseControl);
    if (cruiseControl!=null){ this.cruiseControl= new CruiseControlSpecBuilder(cruiseControl); _visitables.get("cruiseControl").add(this.cruiseControl);} else { this.cruiseControl = null; _visitables.get("cruiseControl").remove(this.cruiseControl); } return (A) this;
  }
  public boolean hasCruiseControl() {
    return this.cruiseControl != null;
  }
  public CruiseControlNested<A> withNewCruiseControl() {
    return new CruiseControlNested(null);
  }
  public CruiseControlNested<A> withNewCruiseControlLike(CruiseControlSpec item) {
    return new CruiseControlNested(item);
  }
  public CruiseControlNested<A> editCruiseControl() {
    return withNewCruiseControlLike(java.util.Optional.ofNullable(buildCruiseControl()).orElse(null));
  }
  public CruiseControlNested<A> editOrNewCruiseControl() {
    return withNewCruiseControlLike(java.util.Optional.ofNullable(buildCruiseControl()).orElse(new CruiseControlSpecBuilder().build()));
  }
  public CruiseControlNested<A> editOrNewCruiseControlLike(CruiseControlSpec item) {
    return withNewCruiseControlLike(java.util.Optional.ofNullable(buildCruiseControl()).orElse(item));
  }
  public CertificateAuthority buildClientsCa() {
    return this.clientsCa!=null ?this.clientsCa.build():null;
  }
  public A withClientsCa(CertificateAuthority clientsCa) {
    _visitables.get("clientsCa").remove(this.clientsCa);
    if (clientsCa!=null){ this.clientsCa= new CertificateAuthorityBuilder(clientsCa); _visitables.get("clientsCa").add(this.clientsCa);} else { this.clientsCa = null; _visitables.get("clientsCa").remove(this.clientsCa); } return (A) this;
  }
  public boolean hasClientsCa() {
    return this.clientsCa != null;
  }
  public ClientsCaNested<A> withNewClientsCa() {
    return new ClientsCaNested(null);
  }
  public ClientsCaNested<A> withNewClientsCaLike(CertificateAuthority item) {
    return new ClientsCaNested(item);
  }
  public ClientsCaNested<A> editClientsCa() {
    return withNewClientsCaLike(java.util.Optional.ofNullable(buildClientsCa()).orElse(null));
  }
  public ClientsCaNested<A> editOrNewClientsCa() {
    return withNewClientsCaLike(java.util.Optional.ofNullable(buildClientsCa()).orElse(new CertificateAuthorityBuilder().build()));
  }
  public ClientsCaNested<A> editOrNewClientsCaLike(CertificateAuthority item) {
    return withNewClientsCaLike(java.util.Optional.ofNullable(buildClientsCa()).orElse(item));
  }
  public A addToMaintenanceTimeWindows(int index,String item) {
    if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new ArrayList<String>();}
    this.maintenanceTimeWindows.add(index, item);
    return (A)this;
  }
  public A setToMaintenanceTimeWindows(int index,String item) {
    if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new ArrayList<String>();}
    this.maintenanceTimeWindows.set(index, item); return (A)this;
  }
  public A addToMaintenanceTimeWindows(java.lang.String... items) {
    if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new ArrayList<String>();}
    for (String item : items) {this.maintenanceTimeWindows.add(item);} return (A)this;
  }
  public A addAllToMaintenanceTimeWindows(Collection<String> items) {
    if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new ArrayList<String>();}
    for (String item : items) {this.maintenanceTimeWindows.add(item);} return (A)this;
  }
  public A removeFromMaintenanceTimeWindows(java.lang.String... items) {
    if (this.maintenanceTimeWindows == null) return (A)this;
    for (String item : items) { this.maintenanceTimeWindows.remove(item);} return (A)this;
  }
  public A removeAllFromMaintenanceTimeWindows(Collection<String> items) {
    if (this.maintenanceTimeWindows == null) return (A)this;
    for (String item : items) { this.maintenanceTimeWindows.remove(item);} return (A)this;
  }
  public List<String> getMaintenanceTimeWindows() {
    return this.maintenanceTimeWindows;
  }
  public String getMaintenanceTimeWindow(int index) {
    return this.maintenanceTimeWindows.get(index);
  }
  public String getFirstMaintenanceTimeWindow() {
    return this.maintenanceTimeWindows.get(0);
  }
  public String getLastMaintenanceTimeWindow() {
    return this.maintenanceTimeWindows.get(maintenanceTimeWindows.size() - 1);
  }
  public String getMatchingMaintenanceTimeWindow(Predicate<String> predicate) {
    for (String item: maintenanceTimeWindows) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingMaintenanceTimeWindow(Predicate<String> predicate) {
    for (String item: maintenanceTimeWindows) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMaintenanceTimeWindows(List<String> maintenanceTimeWindows) {
    if (maintenanceTimeWindows != null) {this.maintenanceTimeWindows = new ArrayList(); for (String item : maintenanceTimeWindows){this.addToMaintenanceTimeWindows(item);}} else { this.maintenanceTimeWindows = null;} return (A) this;
  }
  public A withMaintenanceTimeWindows(java.lang.String... maintenanceTimeWindows) {
    if (this.maintenanceTimeWindows != null) {this.maintenanceTimeWindows.clear(); _visitables.remove("maintenanceTimeWindows"); }
    if (maintenanceTimeWindows != null) {for (String item :maintenanceTimeWindows){ this.addToMaintenanceTimeWindows(item);}} return (A) this;
  }
  public boolean hasMaintenanceTimeWindows() {
    return maintenanceTimeWindows != null && !maintenanceTimeWindows.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaSpecFluent that = (KafkaSpecFluent) o;
    if (!java.util.Objects.equals(kafka, that.kafka)) return false;

    if (!java.util.Objects.equals(zookeeper, that.zookeeper)) return false;

    if (!java.util.Objects.equals(entityOperator, that.entityOperator)) return false;

    if (!java.util.Objects.equals(clusterCa, that.clusterCa)) return false;

    if (!java.util.Objects.equals(jmxTrans, that.jmxTrans)) return false;

    if (!java.util.Objects.equals(kafkaExporter, that.kafkaExporter)) return false;

    if (!java.util.Objects.equals(cruiseControl, that.cruiseControl)) return false;

    if (!java.util.Objects.equals(clientsCa, that.clientsCa)) return false;

    if (!java.util.Objects.equals(maintenanceTimeWindows, that.maintenanceTimeWindows)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(kafka,  zookeeper,  entityOperator,  clusterCa,  jmxTrans,  kafkaExporter,  cruiseControl,  clientsCa,  maintenanceTimeWindows,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kafka != null) { sb.append("kafka:"); sb.append(kafka + ","); }
    if (zookeeper != null) { sb.append("zookeeper:"); sb.append(zookeeper + ","); }
    if (entityOperator != null) { sb.append("entityOperator:"); sb.append(entityOperator + ","); }
    if (clusterCa != null) { sb.append("clusterCa:"); sb.append(clusterCa + ","); }
    if (jmxTrans != null) { sb.append("jmxTrans:"); sb.append(jmxTrans + ","); }
    if (kafkaExporter != null) { sb.append("kafkaExporter:"); sb.append(kafkaExporter + ","); }
    if (cruiseControl != null) { sb.append("cruiseControl:"); sb.append(cruiseControl + ","); }
    if (clientsCa != null) { sb.append("clientsCa:"); sb.append(clientsCa + ","); }
    if (maintenanceTimeWindows != null && !maintenanceTimeWindows.isEmpty()) { sb.append("maintenanceTimeWindows:"); sb.append(maintenanceTimeWindows); }
    sb.append("}");
    return sb.toString();
  }
  public class KafkaNested<N> extends KafkaClusterSpecFluent<KafkaNested<N>> implements Nested<N>{
    KafkaNested(KafkaClusterSpec item) {
      this.builder = new KafkaClusterSpecBuilder(this, item);
    }
    KafkaClusterSpecBuilder builder;
    public N and() {
      return (N) KafkaSpecFluent.this.withKafka(builder.build());
    }
    public N endKafka() {
      return and();
    }
    
  }
  public class ZookeeperNested<N> extends ZookeeperClusterSpecFluent<ZookeeperNested<N>> implements Nested<N>{
    ZookeeperNested(ZookeeperClusterSpec item) {
      this.builder = new ZookeeperClusterSpecBuilder(this, item);
    }
    ZookeeperClusterSpecBuilder builder;
    public N and() {
      return (N) KafkaSpecFluent.this.withZookeeper(builder.build());
    }
    public N endZookeeper() {
      return and();
    }
    
  }
  public class EntityOperatorNested<N> extends EntityOperatorSpecFluent<EntityOperatorNested<N>> implements Nested<N>{
    EntityOperatorNested(EntityOperatorSpec item) {
      this.builder = new EntityOperatorSpecBuilder(this, item);
    }
    EntityOperatorSpecBuilder builder;
    public N and() {
      return (N) KafkaSpecFluent.this.withEntityOperator(builder.build());
    }
    public N endEntityOperator() {
      return and();
    }
    
  }
  public class ClusterCaNested<N> extends CertificateAuthorityFluent<ClusterCaNested<N>> implements Nested<N>{
    ClusterCaNested(CertificateAuthority item) {
      this.builder = new CertificateAuthorityBuilder(this, item);
    }
    CertificateAuthorityBuilder builder;
    public N and() {
      return (N) KafkaSpecFluent.this.withClusterCa(builder.build());
    }
    public N endClusterCa() {
      return and();
    }
    
  }
  public class JmxTransNested<N> extends JmxTransSpecFluent<JmxTransNested<N>> implements Nested<N>{
    JmxTransNested(JmxTransSpec item) {
      this.builder = new JmxTransSpecBuilder(this, item);
    }
    JmxTransSpecBuilder builder;
    public N and() {
      return (N) KafkaSpecFluent.this.withJmxTrans(builder.build());
    }
    public N endJmxTrans() {
      return and();
    }
    
  }
  public class KafkaExporterNested<N> extends KafkaExporterSpecFluent<KafkaExporterNested<N>> implements Nested<N>{
    KafkaExporterNested(KafkaExporterSpec item) {
      this.builder = new KafkaExporterSpecBuilder(this, item);
    }
    KafkaExporterSpecBuilder builder;
    public N and() {
      return (N) KafkaSpecFluent.this.withKafkaExporter(builder.build());
    }
    public N endKafkaExporter() {
      return and();
    }
    
  }
  public class CruiseControlNested<N> extends CruiseControlSpecFluent<CruiseControlNested<N>> implements Nested<N>{
    CruiseControlNested(CruiseControlSpec item) {
      this.builder = new CruiseControlSpecBuilder(this, item);
    }
    CruiseControlSpecBuilder builder;
    public N and() {
      return (N) KafkaSpecFluent.this.withCruiseControl(builder.build());
    }
    public N endCruiseControl() {
      return and();
    }
    
  }
  public class ClientsCaNested<N> extends CertificateAuthorityFluent<ClientsCaNested<N>> implements Nested<N>{
    ClientsCaNested(CertificateAuthority item) {
      this.builder = new CertificateAuthorityBuilder(this, item);
    }
    CertificateAuthorityBuilder builder;
    public N and() {
      return (N) KafkaSpecFluent.this.withClientsCa(builder.build());
    }
    public N endClientsCa() {
      return and();
    }
    
  }
  
}