package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaUserAuthorizationSimpleBuilder extends KafkaUserAuthorizationSimpleFluent<KafkaUserAuthorizationSimpleBuilder> implements VisitableBuilder<KafkaUserAuthorizationSimple,KafkaUserAuthorizationSimpleBuilder>{
  public KafkaUserAuthorizationSimpleBuilder() {
    this(false);
  }
  public KafkaUserAuthorizationSimpleBuilder(Boolean validationEnabled) {
    this(new KafkaUserAuthorizationSimple(), validationEnabled);
  }
  public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimpleFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimpleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaUserAuthorizationSimple(), validationEnabled);
  }
  public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimpleFluent<?> fluent,KafkaUserAuthorizationSimple instance) {
    this(fluent, instance, false);
  }
  public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimpleFluent<?> fluent,KafkaUserAuthorizationSimple instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaUserAuthorizationSimple());

    if (instance != null) {
      fluent.withAcls(instance.getAcls());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimple instance) {
    this(instance,false);
  }
  public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimple instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaUserAuthorizationSimple());

    if (instance != null) {
      this.withAcls(instance.getAcls());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaUserAuthorizationSimpleFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaUserAuthorizationSimple build() {
    KafkaUserAuthorizationSimple buildable = new KafkaUserAuthorizationSimple();
    buildable.setAcls(fluent.buildAcls());
    return buildable;
  }
  
}