package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaUserQuotasBuilder extends KafkaUserQuotasFluent<KafkaUserQuotasBuilder> implements VisitableBuilder<KafkaUserQuotas,KafkaUserQuotasBuilder>{
  public KafkaUserQuotasBuilder() {
    this(false);
  }
  public KafkaUserQuotasBuilder(Boolean validationEnabled) {
    this(new KafkaUserQuotas(), validationEnabled);
  }
  public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaUserQuotas(), validationEnabled);
  }
  public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent,KafkaUserQuotas instance) {
    this(fluent, instance, false);
  }
  public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent,KafkaUserQuotas instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaUserQuotas());

    if (instance != null) {
      fluent.withProducerByteRate(instance.getProducerByteRate());
      fluent.withConsumerByteRate(instance.getConsumerByteRate());
      fluent.withRequestPercentage(instance.getRequestPercentage());
      fluent.withControllerMutationRate(instance.getControllerMutationRate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaUserQuotasBuilder(KafkaUserQuotas instance) {
    this(instance,false);
  }
  public KafkaUserQuotasBuilder(KafkaUserQuotas instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaUserQuotas());

    if (instance != null) {
      this.withProducerByteRate(instance.getProducerByteRate());
      this.withConsumerByteRate(instance.getConsumerByteRate());
      this.withRequestPercentage(instance.getRequestPercentage());
      this.withControllerMutationRate(instance.getControllerMutationRate());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaUserQuotasFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaUserQuotas build() {
    KafkaUserQuotas buildable = new KafkaUserQuotas();
    buildable.setProducerByteRate(fluent.getProducerByteRate());
    buildable.setConsumerByteRate(fluent.getConsumerByteRate());
    buildable.setRequestPercentage(fluent.getRequestPercentage());
    buildable.setControllerMutationRate(fluent.getControllerMutationRate());
    return buildable;
  }
  
}