package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaUserSpecBuilder extends KafkaUserSpecFluent<KafkaUserSpecBuilder> implements VisitableBuilder<KafkaUserSpec,KafkaUserSpecBuilder>{
  public KafkaUserSpecBuilder() {
    this(false);
  }
  public KafkaUserSpecBuilder(Boolean validationEnabled) {
    this(new KafkaUserSpec(), validationEnabled);
  }
  public KafkaUserSpecBuilder(KafkaUserSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaUserSpecBuilder(KafkaUserSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaUserSpec(), validationEnabled);
  }
  public KafkaUserSpecBuilder(KafkaUserSpecFluent<?> fluent,KafkaUserSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaUserSpecBuilder(KafkaUserSpecFluent<?> fluent,KafkaUserSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaUserSpec());

    if (instance != null) {
      fluent.withAuthentication(instance.getAuthentication());
      fluent.withAuthorization(instance.getAuthorization());
      fluent.withQuotas(instance.getQuotas());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaUserSpecBuilder(KafkaUserSpec instance) {
    this(instance,false);
  }
  public KafkaUserSpecBuilder(KafkaUserSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaUserSpec());

    if (instance != null) {
      this.withAuthentication(instance.getAuthentication());
      this.withAuthorization(instance.getAuthorization());
      this.withQuotas(instance.getQuotas());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaUserSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaUserSpec build() {
    KafkaUserSpec buildable = new KafkaUserSpec();
    buildable.setAuthentication(fluent.buildAuthentication());
    buildable.setAuthorization(fluent.buildAuthorization());
    buildable.setQuotas(fluent.buildQuotas());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  
}