package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.template.KafkaUserTemplate;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaUserTemplateFluent;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaUserSpecFluent<A extends KafkaUserSpecFluent<A>> extends SpecFluent<A>{
  public KafkaUserSpecFluent() {
  }
  public KafkaUserSpecFluent(KafkaUserSpec instance) {
    instance = (instance != null ? instance : new KafkaUserSpec());

    if (instance != null) {
      this.withAuthentication(instance.getAuthentication());
      this.withAuthorization(instance.getAuthorization());
      this.withQuotas(instance.getQuotas());
      this.withTemplate(instance.getTemplate());
    }
  }
  private VisitableBuilder<? extends KafkaUserAuthentication,?> authentication;
  private VisitableBuilder<? extends KafkaUserAuthorization,?> authorization;
  private KafkaUserQuotasBuilder quotas;
  private KafkaUserTemplateBuilder template;
  public KafkaUserAuthentication buildAuthentication() {
    return this.authentication!=null?this.authentication.build():null;
  }
  public A withAuthentication(KafkaUserAuthentication authentication) {
    if (authentication==null){ this.authentication = null; _visitables.remove("authentication"); return (A) this;}
    VisitableBuilder<? extends KafkaUserAuthentication,?> builder = builder(authentication); _visitables.get("authentication").clear();_visitables.get("authentication").add(builder);this.authentication = builder;
    return (A) this;
  }
  public boolean hasAuthentication() {
    return this.authentication != null;
  }
  public KafkaUserTlsClientAuthenticationNested<A> withNewKafkaUserTlsClientAuthentication() {
    return new KafkaUserTlsClientAuthenticationNested(null);
  }
  public KafkaUserTlsClientAuthenticationNested<A> withNewKafkaUserTlsClientAuthenticationLike(KafkaUserTlsClientAuthentication item) {
    return new KafkaUserTlsClientAuthenticationNested(item);
  }
  public KafkaUserTlsExternalClientAuthenticationNested<A> withNewKafkaUserTlsExternalClientAuthentication() {
    return new KafkaUserTlsExternalClientAuthenticationNested(null);
  }
  public KafkaUserTlsExternalClientAuthenticationNested<A> withNewKafkaUserTlsExternalClientAuthenticationLike(KafkaUserTlsExternalClientAuthentication item) {
    return new KafkaUserTlsExternalClientAuthenticationNested(item);
  }
  public KafkaUserScramSha512ClientAuthenticationNested<A> withNewKafkaUserScramSha512ClientAuthentication() {
    return new KafkaUserScramSha512ClientAuthenticationNested(null);
  }
  public KafkaUserScramSha512ClientAuthenticationNested<A> withNewKafkaUserScramSha512ClientAuthenticationLike(KafkaUserScramSha512ClientAuthentication item) {
    return new KafkaUserScramSha512ClientAuthenticationNested(item);
  }
  public KafkaUserAuthorization buildAuthorization() {
    return this.authorization!=null?this.authorization.build():null;
  }
  public A withAuthorization(KafkaUserAuthorization authorization) {
    if (authorization==null){ this.authorization = null; _visitables.remove("authorization"); return (A) this;}
    VisitableBuilder<? extends KafkaUserAuthorization,?> builder = builder(authorization); _visitables.get("authorization").clear();_visitables.get("authorization").add(builder);this.authorization = builder;
    return (A) this;
  }
  public boolean hasAuthorization() {
    return this.authorization != null;
  }
  public KafkaUserAuthorizationSimpleNested<A> withNewKafkaUserAuthorizationSimple() {
    return new KafkaUserAuthorizationSimpleNested(null);
  }
  public KafkaUserAuthorizationSimpleNested<A> withNewKafkaUserAuthorizationSimpleLike(KafkaUserAuthorizationSimple item) {
    return new KafkaUserAuthorizationSimpleNested(item);
  }
  public KafkaUserQuotas buildQuotas() {
    return this.quotas!=null ?this.quotas.build():null;
  }
  public A withQuotas(KafkaUserQuotas quotas) {
    _visitables.get("quotas").remove(this.quotas);
    if (quotas!=null){ this.quotas= new KafkaUserQuotasBuilder(quotas); _visitables.get("quotas").add(this.quotas);} else { this.quotas = null; _visitables.get("quotas").remove(this.quotas); } return (A) this;
  }
  public boolean hasQuotas() {
    return this.quotas != null;
  }
  public QuotasNested<A> withNewQuotas() {
    return new QuotasNested(null);
  }
  public QuotasNested<A> withNewQuotasLike(KafkaUserQuotas item) {
    return new QuotasNested(item);
  }
  public QuotasNested<A> editQuotas() {
    return withNewQuotasLike(java.util.Optional.ofNullable(buildQuotas()).orElse(null));
  }
  public QuotasNested<A> editOrNewQuotas() {
    return withNewQuotasLike(java.util.Optional.ofNullable(buildQuotas()).orElse(new KafkaUserQuotasBuilder().build()));
  }
  public QuotasNested<A> editOrNewQuotasLike(KafkaUserQuotas item) {
    return withNewQuotasLike(java.util.Optional.ofNullable(buildQuotas()).orElse(item));
  }
  public KafkaUserTemplate buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(KafkaUserTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new KafkaUserTemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  public TemplateNested<A> withNewTemplateLike(KafkaUserTemplate item) {
    return new TemplateNested(item);
  }
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new KafkaUserTemplateBuilder().build()));
  }
  public TemplateNested<A> editOrNewTemplateLike(KafkaUserTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaUserSpecFluent that = (KafkaUserSpecFluent) o;
    if (!java.util.Objects.equals(authentication, that.authentication)) return false;

    if (!java.util.Objects.equals(authorization, that.authorization)) return false;

    if (!java.util.Objects.equals(quotas, that.quotas)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authentication,  authorization,  quotas,  template,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authentication != null) { sb.append("authentication:"); sb.append(authentication + ","); }
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (quotas != null) { sb.append("quotas:"); sb.append(quotas + ","); }
    if (template != null) { sb.append("template:"); sb.append(template); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model."+"KafkaUserTlsClientAuthentication": return (VisitableBuilder<T, ?>)new KafkaUserTlsClientAuthenticationBuilder((KafkaUserTlsClientAuthentication) item);
    case "io.strimzi.api.kafka.model."+"KafkaUserTlsExternalClientAuthentication": return (VisitableBuilder<T, ?>)new KafkaUserTlsExternalClientAuthenticationBuilder((KafkaUserTlsExternalClientAuthentication) item);
    case "io.strimzi.api.kafka.model."+"KafkaUserScramSha512ClientAuthentication": return (VisitableBuilder<T, ?>)new KafkaUserScramSha512ClientAuthenticationBuilder((KafkaUserScramSha512ClientAuthentication) item);
    case "io.strimzi.api.kafka.model."+"KafkaUserAuthorizationSimple": return (VisitableBuilder<T, ?>)new KafkaUserAuthorizationSimpleBuilder((KafkaUserAuthorizationSimple) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class KafkaUserTlsClientAuthenticationNested<N> extends KafkaUserTlsClientAuthenticationFluent<KafkaUserTlsClientAuthenticationNested<N>> implements Nested<N>{
    KafkaUserTlsClientAuthenticationNested(KafkaUserTlsClientAuthentication item) {
      this.builder = new KafkaUserTlsClientAuthenticationBuilder(this, item);
    }
    KafkaUserTlsClientAuthenticationBuilder builder;
    public N and() {
      return (N) KafkaUserSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaUserTlsClientAuthentication() {
      return and();
    }
    
  }
  public class KafkaUserTlsExternalClientAuthenticationNested<N> extends KafkaUserTlsExternalClientAuthenticationFluent<KafkaUserTlsExternalClientAuthenticationNested<N>> implements Nested<N>{
    KafkaUserTlsExternalClientAuthenticationNested(KafkaUserTlsExternalClientAuthentication item) {
      this.builder = new KafkaUserTlsExternalClientAuthenticationBuilder(this, item);
    }
    KafkaUserTlsExternalClientAuthenticationBuilder builder;
    public N and() {
      return (N) KafkaUserSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaUserTlsExternalClientAuthentication() {
      return and();
    }
    
  }
  public class KafkaUserScramSha512ClientAuthenticationNested<N> extends KafkaUserScramSha512ClientAuthenticationFluent<KafkaUserScramSha512ClientAuthenticationNested<N>> implements Nested<N>{
    KafkaUserScramSha512ClientAuthenticationNested(KafkaUserScramSha512ClientAuthentication item) {
      this.builder = new KafkaUserScramSha512ClientAuthenticationBuilder(this, item);
    }
    KafkaUserScramSha512ClientAuthenticationBuilder builder;
    public N and() {
      return (N) KafkaUserSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaUserScramSha512ClientAuthentication() {
      return and();
    }
    
  }
  public class KafkaUserAuthorizationSimpleNested<N> extends KafkaUserAuthorizationSimpleFluent<KafkaUserAuthorizationSimpleNested<N>> implements Nested<N>{
    KafkaUserAuthorizationSimpleNested(KafkaUserAuthorizationSimple item) {
      this.builder = new KafkaUserAuthorizationSimpleBuilder(this, item);
    }
    KafkaUserAuthorizationSimpleBuilder builder;
    public N and() {
      return (N) KafkaUserSpecFluent.this.withAuthorization(builder.build());
    }
    public N endKafkaUserAuthorizationSimple() {
      return and();
    }
    
  }
  public class QuotasNested<N> extends KafkaUserQuotasFluent<QuotasNested<N>> implements Nested<N>{
    QuotasNested(KafkaUserQuotas item) {
      this.builder = new KafkaUserQuotasBuilder(this, item);
    }
    KafkaUserQuotasBuilder builder;
    public N and() {
      return (N) KafkaUserSpecFluent.this.withQuotas(builder.build());
    }
    public N endQuotas() {
      return and();
    }
    
  }
  public class TemplateNested<N> extends KafkaUserTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(KafkaUserTemplate item) {
      this.builder = new KafkaUserTemplateBuilder(this, item);
    }
    KafkaUserTemplateBuilder builder;
    public N and() {
      return (N) KafkaUserSpecFluent.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}