package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeBuilder extends ProbeFluent<ProbeBuilder> implements VisitableBuilder<Probe,ProbeBuilder>{
  public ProbeBuilder() {
    this(false);
  }
  public ProbeBuilder(Boolean validationEnabled) {
    this(new Probe(), validationEnabled);
  }
  public ProbeBuilder(ProbeFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeBuilder(ProbeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Probe(), validationEnabled);
  }
  public ProbeBuilder(ProbeFluent<?> fluent,Probe instance) {
    this(fluent, instance, false);
  }
  public ProbeBuilder(ProbeFluent<?> fluent,Probe instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Probe());

    if (instance != null) {
      fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withPeriodSeconds(instance.getPeriodSeconds());
      fluent.withSuccessThreshold(instance.getSuccessThreshold());
      fluent.withFailureThreshold(instance.getFailureThreshold());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProbeBuilder(Probe instance) {
    this(instance,false);
  }
  public ProbeBuilder(Probe instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Probe());

    if (instance != null) {
      this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withPeriodSeconds(instance.getPeriodSeconds());
      this.withSuccessThreshold(instance.getSuccessThreshold());
      this.withFailureThreshold(instance.getFailureThreshold());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProbeFluent<?> fluent;
  Boolean validationEnabled;
  public Probe build() {
    Probe buildable = new Probe(fluent.getInitialDelaySeconds(),fluent.getTimeoutSeconds());
    buildable.setPeriodSeconds(fluent.getPeriodSeconds());
    buildable.setSuccessThreshold(fluent.getSuccessThreshold());
    buildable.setFailureThreshold(fluent.getFailureThreshold());
    return buildable;
  }
  
}