package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StrimziPodSetBuilder extends StrimziPodSetFluent<StrimziPodSetBuilder> implements VisitableBuilder<StrimziPodSet,StrimziPodSetBuilder>{
  public StrimziPodSetBuilder() {
    this(false);
  }
  public StrimziPodSetBuilder(Boolean validationEnabled) {
    this(new StrimziPodSet(), validationEnabled);
  }
  public StrimziPodSetBuilder(StrimziPodSetFluent<?> fluent) {
    this(fluent, false);
  }
  public StrimziPodSetBuilder(StrimziPodSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StrimziPodSet(), validationEnabled);
  }
  public StrimziPodSetBuilder(StrimziPodSetFluent<?> fluent,StrimziPodSet instance) {
    this(fluent, instance, false);
  }
  public StrimziPodSetBuilder(StrimziPodSetFluent<?> fluent,StrimziPodSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StrimziPodSet());

    if (instance != null) {
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StrimziPodSetBuilder(StrimziPodSet instance) {
    this(instance,false);
  }
  public StrimziPodSetBuilder(StrimziPodSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StrimziPodSet());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  StrimziPodSetFluent<?> fluent;
  Boolean validationEnabled;
  public StrimziPodSet build() {
    StrimziPodSet buildable = new StrimziPodSet(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  
}