package io.strimzi.api.kafka.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StrimziPodSetSpecFluent<A extends StrimziPodSetSpecFluent<A>> extends SpecFluent<A>{
  public StrimziPodSetSpecFluent() {
  }
  public StrimziPodSetSpecFluent(StrimziPodSetSpec instance) {
    instance = (instance != null ? instance : new StrimziPodSetSpec());

    if (instance != null) {
      this.withSelector(instance.getSelector());
      this.withPods(instance.getPods());
    }
  }
  private LabelSelector selector;
  private List<Map<String,Object>> pods;
  public LabelSelector getSelector() {
    return this.selector;
  }
  public A withSelector(LabelSelector selector) {
    this.selector=selector; return (A) this;
  }
  public boolean hasSelector() {
    return this.selector != null;
  }
  public A addToPods(int index,Map<String,Object> item) {
    if (this.pods == null) {this.pods = new ArrayList<Map<String,Object>>();}
    this.pods.add(index, item);
    return (A)this;
  }
  public A setToPods(int index,Map<String,Object> item) {
    if (this.pods == null) {this.pods = new ArrayList<Map<String,Object>>();}
    this.pods.set(index, item); return (A)this;
  }
  public A addToPods(Map<String,Object>... items) {
    if (this.pods == null) {this.pods = new ArrayList<Map<String,Object>>();}
    for (Map<String,Object> item : items) {this.pods.add(item);} return (A)this;
  }
  public A addAllToPods(Collection<Map<String,Object>> items) {
    if (this.pods == null) {this.pods = new ArrayList<Map<String,Object>>();}
    for (Map<String,Object> item : items) {this.pods.add(item);} return (A)this;
  }
  public A removeFromPods(Map<String,Object>... items) {
    if (this.pods == null) return (A)this;
    for (Map<String,Object> item : items) { this.pods.remove(item);} return (A)this;
  }
  public A removeAllFromPods(Collection<Map<String,Object>> items) {
    if (this.pods == null) return (A)this;
    for (Map<String,Object> item : items) { this.pods.remove(item);} return (A)this;
  }
  public List<Map<String,Object>> getPods() {
    return this.pods;
  }
  public Map<String,Object> getPod(int index) {
    return this.pods.get(index);
  }
  public Map<String,Object> getFirstPod() {
    return this.pods.get(0);
  }
  public Map<String,Object> getLastPod() {
    return this.pods.get(pods.size() - 1);
  }
  public Map<String,Object> getMatchingPod(Predicate<Map<String,Object>> predicate) {
    for (Map<String,Object> item: pods) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingPod(Predicate<Map<String,Object>> predicate) {
    for (Map<String,Object> item: pods) { if(predicate.test(item)){ return true;} } return false;
  }
  public <K,V>A withPods(List<Map<String,Object>> pods) {
    if (pods != null) {this.pods = new ArrayList(); for (Map<String,Object> item : pods){this.addToPods(item);}} else { this.pods = null;} return (A) this;
  }
  public A withPods(Map<String,Object>... pods) {
    if (this.pods != null) {this.pods.clear(); _visitables.remove("pods"); }
    if (pods != null) {for (Map<String,Object> item :pods){ this.addToPods(item);}} return (A) this;
  }
  public boolean hasPods() {
    return pods != null && !pods.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StrimziPodSetSpecFluent that = (StrimziPodSetSpecFluent) o;
    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(pods, that.pods)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(selector,  pods,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (pods != null && !pods.isEmpty()) { sb.append("pods:"); sb.append(pods); }
    sb.append("}");
    return sb.toString();
  }
  
}