package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SystemPropertyBuilder extends SystemPropertyFluent<SystemPropertyBuilder> implements VisitableBuilder<SystemProperty,SystemPropertyBuilder>{
  public SystemPropertyBuilder() {
    this(false);
  }
  public SystemPropertyBuilder(Boolean validationEnabled) {
    this(new SystemProperty(), validationEnabled);
  }
  public SystemPropertyBuilder(SystemPropertyFluent<?> fluent) {
    this(fluent, false);
  }
  public SystemPropertyBuilder(SystemPropertyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SystemProperty(), validationEnabled);
  }
  public SystemPropertyBuilder(SystemPropertyFluent<?> fluent,SystemProperty instance) {
    this(fluent, instance, false);
  }
  public SystemPropertyBuilder(SystemPropertyFluent<?> fluent,SystemProperty instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SystemProperty());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SystemPropertyBuilder(SystemProperty instance) {
    this(instance,false);
  }
  public SystemPropertyBuilder(SystemProperty instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SystemProperty());

    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  SystemPropertyFluent<?> fluent;
  Boolean validationEnabled;
  public SystemProperty build() {
    SystemProperty buildable = new SystemProperty();
    buildable.setName(fluent.getName());
    buildable.setValue(fluent.getValue());
    return buildable;
  }
  
}