package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TlsSidecarBuilder extends TlsSidecarFluent<TlsSidecarBuilder> implements VisitableBuilder<TlsSidecar,TlsSidecarBuilder>{
  public TlsSidecarBuilder() {
    this(false);
  }
  public TlsSidecarBuilder(Boolean validationEnabled) {
    this(new TlsSidecar(), validationEnabled);
  }
  public TlsSidecarBuilder(TlsSidecarFluent<?> fluent) {
    this(fluent, false);
  }
  public TlsSidecarBuilder(TlsSidecarFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TlsSidecar(), validationEnabled);
  }
  public TlsSidecarBuilder(TlsSidecarFluent<?> fluent,TlsSidecar instance) {
    this(fluent, instance, false);
  }
  public TlsSidecarBuilder(TlsSidecarFluent<?> fluent,TlsSidecar instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TlsSidecar());

    if (instance != null) {
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withImage(instance.getImage());
      fluent.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TlsSidecarBuilder(TlsSidecar instance) {
    this(instance,false);
  }
  public TlsSidecarBuilder(TlsSidecar instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TlsSidecar());

    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  TlsSidecarFluent<?> fluent;
  Boolean validationEnabled;
  public TlsSidecar build() {
    TlsSidecar buildable = new TlsSidecar();
    buildable.setLogLevel(fluent.getLogLevel());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    return buildable;
  }
  
}