package io.strimzi.api.kafka.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TlsSidecarFluent<A extends TlsSidecarFluent<A>> extends SidecarFluent<A>{
  public TlsSidecarFluent() {
  }
  public TlsSidecarFluent(TlsSidecar instance) {
    instance = (instance != null ? instance : new TlsSidecar());

    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
    }
  }
  private TlsSidecarLogLevel logLevel;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  public TlsSidecarLogLevel getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(TlsSidecarLogLevel logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public Probe buildLivenessProbe() {
    return this.livenessProbe!=null ?this.livenessProbe.build():null;
  }
  public A withLivenessProbe(Probe livenessProbe) {
    _visitables.get("livenessProbe").remove(this.livenessProbe);
    if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} else { this.livenessProbe = null; _visitables.get("livenessProbe").remove(this.livenessProbe); } return (A) this;
  }
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  public Probe buildReadinessProbe() {
    return this.readinessProbe!=null ?this.readinessProbe.build():null;
  }
  public A withReadinessProbe(Probe readinessProbe) {
    _visitables.get("readinessProbe").remove(this.readinessProbe);
    if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} else { this.readinessProbe = null; _visitables.get("readinessProbe").remove(this.readinessProbe); } return (A) this;
  }
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TlsSidecarFluent that = (TlsSidecarFluent) o;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;

    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;

    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(logLevel,  livenessProbe,  readinessProbe,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe); }
    sb.append("}");
    return sb.toString();
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) TlsSidecarFluent.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe() {
      return and();
    }
    
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) TlsSidecarFluent.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe() {
      return and();
    }
    
  }
  
}