package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ZookeeperClusterSpecBuilder extends ZookeeperClusterSpecFluent<ZookeeperClusterSpecBuilder> implements VisitableBuilder<ZookeeperClusterSpec,ZookeeperClusterSpecBuilder>{
  public ZookeeperClusterSpecBuilder() {
    this(false);
  }
  public ZookeeperClusterSpecBuilder(Boolean validationEnabled) {
    this(new ZookeeperClusterSpec(), validationEnabled);
  }
  public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ZookeeperClusterSpec(), validationEnabled);
  }
  public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent,ZookeeperClusterSpec instance) {
    this(fluent, instance, false);
  }
  public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent,ZookeeperClusterSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ZookeeperClusterSpec());

    if (instance != null) {
      fluent.withStorage(instance.getStorage());
      fluent.withConfig(instance.getConfig());
      fluent.withLogging(instance.getLogging());
      fluent.withReplicas(instance.getReplicas());
      fluent.withImage(instance.getImage());
      fluent.withResources(instance.getResources());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withJvmOptions(instance.getJvmOptions());
      fluent.withJmxOptions(instance.getJmxOptions());
      fluent.withMetricsConfig(instance.getMetricsConfig());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ZookeeperClusterSpecBuilder(ZookeeperClusterSpec instance) {
    this(instance,false);
  }
  public ZookeeperClusterSpecBuilder(ZookeeperClusterSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ZookeeperClusterSpec());

    if (instance != null) {
      this.withStorage(instance.getStorage());
      this.withConfig(instance.getConfig());
      this.withLogging(instance.getLogging());
      this.withReplicas(instance.getReplicas());
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withJvmOptions(instance.getJvmOptions());
      this.withJmxOptions(instance.getJmxOptions());
      this.withMetricsConfig(instance.getMetricsConfig());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  ZookeeperClusterSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ZookeeperClusterSpec build() {
    ZookeeperClusterSpec buildable = new ZookeeperClusterSpec();
    buildable.setStorage(fluent.buildStorage());
    buildable.setConfig(fluent.getConfig());
    buildable.setLogging(fluent.buildLogging());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setJmxOptions(fluent.buildJmxOptions());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  
}