package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.storage.SingleVolumeStorage;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluent;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ZookeeperClusterSpecFluent<A extends ZookeeperClusterSpecFluent<A>> extends BaseFluent<A>{
  public ZookeeperClusterSpecFluent() {
  }
  public ZookeeperClusterSpecFluent(ZookeeperClusterSpec instance) {
    instance = (instance != null ? instance : new ZookeeperClusterSpec());

    if (instance != null) {
      this.withStorage(instance.getStorage());
      this.withConfig(instance.getConfig());
      this.withLogging(instance.getLogging());
      this.withReplicas(instance.getReplicas());
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withJvmOptions(instance.getJvmOptions());
      this.withJmxOptions(instance.getJmxOptions());
      this.withMetricsConfig(instance.getMetricsConfig());
      this.withTemplate(instance.getTemplate());
    }
  }
  private VisitableBuilder<? extends SingleVolumeStorage,?> storage;
  private Map<String,Object> config;
  private VisitableBuilder<? extends Logging,?> logging;
  private int replicas;
  private String image;
  private ResourceRequirements resources;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private JvmOptionsBuilder jvmOptions;
  private KafkaJmxOptionsBuilder jmxOptions;
  private VisitableBuilder<? extends MetricsConfig,?> metricsConfig;
  private ZookeeperClusterTemplateBuilder template;
  public SingleVolumeStorage buildStorage() {
    return this.storage!=null?this.storage.build():null;
  }
  public A withStorage(SingleVolumeStorage storage) {
    if (storage==null){ this.storage = null; _visitables.remove("storage"); return (A) this;}
    VisitableBuilder<? extends SingleVolumeStorage,?> builder = builder(storage); _visitables.get("storage").clear();_visitables.get("storage").add(builder);this.storage = builder;
    return (A) this;
  }
  public boolean hasStorage() {
    return this.storage != null;
  }
  public PersistentClaimStorageNested<A> withNewPersistentClaimStorage() {
    return new PersistentClaimStorageNested(null);
  }
  public PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(PersistentClaimStorage item) {
    return new PersistentClaimStorageNested(item);
  }
  public EphemeralStorageNested<A> withNewEphemeralStorage() {
    return new EphemeralStorageNested(null);
  }
  public EphemeralStorageNested<A> withNewEphemeralStorageLike(EphemeralStorage item) {
    return new EphemeralStorageNested(item);
  }
  public A addToConfig(String key,Object value) {
    if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap(); }
    if(key != null && value != null) {this.config.put(key, value);} return (A)this;
  }
  public A addToConfig(Map<String,Object> map) {
    if(this.config == null && map != null) { this.config = new LinkedHashMap(); }
    if(map != null) { this.config.putAll(map);} return (A)this;
  }
  public A removeFromConfig(String key) {
    if(this.config == null) { return (A) this; }
    if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
  }
  public A removeFromConfig(Map<String,Object> map) {
    if(this.config == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getConfig() {
    return this.config;
  }
  public <K,V>A withConfig(Map<String,Object> config) {
    if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap(config);} return (A) this;
  }
  public boolean hasConfig() {
    return this.config != null;
  }
  public Logging buildLogging() {
    return this.logging!=null?this.logging.build():null;
  }
  public A withLogging(Logging logging) {
    if (logging==null){ this.logging = null; _visitables.remove("logging"); return (A) this;}
    VisitableBuilder<? extends Logging,?> builder = builder(logging); _visitables.get("logging").clear();_visitables.get("logging").add(builder);this.logging = builder;
    return (A) this;
  }
  public boolean hasLogging() {
    return this.logging != null;
  }
  public ExternalLoggingNested<A> withNewExternalLogging() {
    return new ExternalLoggingNested(null);
  }
  public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
    return new ExternalLoggingNested(item);
  }
  public InlineLoggingNested<A> withNewInlineLogging() {
    return new InlineLoggingNested(null);
  }
  public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
    return new InlineLoggingNested(item);
  }
  public int getReplicas() {
    return this.replicas;
  }
  public A withReplicas(int replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return true;
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public boolean hasImage() {
    return this.image != null;
  }
  public ResourceRequirements getResources() {
    return this.resources;
  }
  public A withResources(ResourceRequirements resources) {
    this.resources=resources; return (A) this;
  }
  public boolean hasResources() {
    return this.resources != null;
  }
  public Probe buildLivenessProbe() {
    return this.livenessProbe!=null ?this.livenessProbe.build():null;
  }
  public A withLivenessProbe(Probe livenessProbe) {
    _visitables.get("livenessProbe").remove(this.livenessProbe);
    if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} else { this.livenessProbe = null; _visitables.get("livenessProbe").remove(this.livenessProbe); } return (A) this;
  }
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  public Probe buildReadinessProbe() {
    return this.readinessProbe!=null ?this.readinessProbe.build():null;
  }
  public A withReadinessProbe(Probe readinessProbe) {
    _visitables.get("readinessProbe").remove(this.readinessProbe);
    if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} else { this.readinessProbe = null; _visitables.get("readinessProbe").remove(this.readinessProbe); } return (A) this;
  }
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  public JvmOptions buildJvmOptions() {
    return this.jvmOptions!=null ?this.jvmOptions.build():null;
  }
  public A withJvmOptions(JvmOptions jvmOptions) {
    _visitables.get("jvmOptions").remove(this.jvmOptions);
    if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} else { this.jvmOptions = null; _visitables.get("jvmOptions").remove(this.jvmOptions); } return (A) this;
  }
  public boolean hasJvmOptions() {
    return this.jvmOptions != null;
  }
  public JvmOptionsNested<A> withNewJvmOptions() {
    return new JvmOptionsNested(null);
  }
  public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
    return new JvmOptionsNested(item);
  }
  public JvmOptionsNested<A> editJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(null));
  }
  public JvmOptionsNested<A> editOrNewJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
  }
  public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(item));
  }
  public KafkaJmxOptions buildJmxOptions() {
    return this.jmxOptions!=null ?this.jmxOptions.build():null;
  }
  public A withJmxOptions(KafkaJmxOptions jmxOptions) {
    _visitables.get("jmxOptions").remove(this.jmxOptions);
    if (jmxOptions!=null){ this.jmxOptions= new KafkaJmxOptionsBuilder(jmxOptions); _visitables.get("jmxOptions").add(this.jmxOptions);} else { this.jmxOptions = null; _visitables.get("jmxOptions").remove(this.jmxOptions); } return (A) this;
  }
  public boolean hasJmxOptions() {
    return this.jmxOptions != null;
  }
  public JmxOptionsNested<A> withNewJmxOptions() {
    return new JmxOptionsNested(null);
  }
  public JmxOptionsNested<A> withNewJmxOptionsLike(KafkaJmxOptions item) {
    return new JmxOptionsNested(item);
  }
  public JmxOptionsNested<A> editJmxOptions() {
    return withNewJmxOptionsLike(java.util.Optional.ofNullable(buildJmxOptions()).orElse(null));
  }
  public JmxOptionsNested<A> editOrNewJmxOptions() {
    return withNewJmxOptionsLike(java.util.Optional.ofNullable(buildJmxOptions()).orElse(new KafkaJmxOptionsBuilder().build()));
  }
  public JmxOptionsNested<A> editOrNewJmxOptionsLike(KafkaJmxOptions item) {
    return withNewJmxOptionsLike(java.util.Optional.ofNullable(buildJmxOptions()).orElse(item));
  }
  public MetricsConfig buildMetricsConfig() {
    return this.metricsConfig!=null?this.metricsConfig.build():null;
  }
  public A withMetricsConfig(MetricsConfig metricsConfig) {
    if (metricsConfig==null){ this.metricsConfig = null; _visitables.remove("metricsConfig"); return (A) this;}
    VisitableBuilder<? extends MetricsConfig,?> builder = builder(metricsConfig); _visitables.get("metricsConfig").clear();_visitables.get("metricsConfig").add(builder);this.metricsConfig = builder;
    return (A) this;
  }
  public boolean hasMetricsConfig() {
    return this.metricsConfig != null;
  }
  public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
    return new JmxPrometheusExporterMetricsConfigNested(null);
  }
  public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
    return new JmxPrometheusExporterMetricsConfigNested(item);
  }
  public ZookeeperClusterTemplate buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(ZookeeperClusterTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new ZookeeperClusterTemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  public TemplateNested<A> withNewTemplateLike(ZookeeperClusterTemplate item) {
    return new TemplateNested(item);
  }
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new ZookeeperClusterTemplateBuilder().build()));
  }
  public TemplateNested<A> editOrNewTemplateLike(ZookeeperClusterTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ZookeeperClusterSpecFluent that = (ZookeeperClusterSpecFluent) o;
    if (!java.util.Objects.equals(storage, that.storage)) return false;

    if (!java.util.Objects.equals(config, that.config)) return false;

    if (!java.util.Objects.equals(logging, that.logging)) return false;

    if (replicas != that.replicas) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;

    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;

    if (!java.util.Objects.equals(jvmOptions, that.jvmOptions)) return false;

    if (!java.util.Objects.equals(jmxOptions, that.jmxOptions)) return false;

    if (!java.util.Objects.equals(metricsConfig, that.metricsConfig)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(storage,  config,  logging,  replicas,  image,  resources,  livenessProbe,  readinessProbe,  jvmOptions,  jmxOptions,  metricsConfig,  template,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (config != null && !config.isEmpty()) { sb.append("config:"); sb.append(config + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    sb.append("replicas:"); sb.append(replicas + ",");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (jvmOptions != null) { sb.append("jvmOptions:"); sb.append(jvmOptions + ","); }
    if (jmxOptions != null) { sb.append("jmxOptions:"); sb.append(jmxOptions + ","); }
    if (metricsConfig != null) { sb.append("metricsConfig:"); sb.append(metricsConfig + ","); }
    if (template != null) { sb.append("template:"); sb.append(template); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.storage."+"PersistentClaimStorage": return (VisitableBuilder<T, ?>)new PersistentClaimStorageBuilder((PersistentClaimStorage) item);
    case "io.strimzi.api.kafka.model.storage."+"EphemeralStorage": return (VisitableBuilder<T, ?>)new EphemeralStorageBuilder((EphemeralStorage) item);
    case "io.strimzi.api.kafka.model."+"ExternalLogging": return (VisitableBuilder<T, ?>)new ExternalLoggingBuilder((ExternalLogging) item);
    case "io.strimzi.api.kafka.model."+"InlineLogging": return (VisitableBuilder<T, ?>)new InlineLoggingBuilder((InlineLogging) item);
    case "io.strimzi.api.kafka.model."+"JmxPrometheusExporterMetrics": return (VisitableBuilder<T, ?>)new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class PersistentClaimStorageNested<N> extends PersistentClaimStorageFluent<PersistentClaimStorageNested<N>> implements Nested<N>{
    PersistentClaimStorageNested(PersistentClaimStorage item) {
      this.builder = new PersistentClaimStorageBuilder(this, item);
    }
    PersistentClaimStorageBuilder builder;
    public N and() {
      return (N) ZookeeperClusterSpecFluent.this.withStorage(builder.build());
    }
    public N endPersistentClaimStorage() {
      return and();
    }
    
  }
  public class EphemeralStorageNested<N> extends EphemeralStorageFluent<EphemeralStorageNested<N>> implements Nested<N>{
    EphemeralStorageNested(EphemeralStorage item) {
      this.builder = new EphemeralStorageBuilder(this, item);
    }
    EphemeralStorageBuilder builder;
    public N and() {
      return (N) ZookeeperClusterSpecFluent.this.withStorage(builder.build());
    }
    public N endEphemeralStorage() {
      return and();
    }
    
  }
  public class ExternalLoggingNested<N> extends ExternalLoggingFluent<ExternalLoggingNested<N>> implements Nested<N>{
    ExternalLoggingNested(ExternalLogging item) {
      this.builder = new ExternalLoggingBuilder(this, item);
    }
    ExternalLoggingBuilder builder;
    public N and() {
      return (N) ZookeeperClusterSpecFluent.this.withLogging(builder.build());
    }
    public N endExternalLogging() {
      return and();
    }
    
  }
  public class InlineLoggingNested<N> extends InlineLoggingFluent<InlineLoggingNested<N>> implements Nested<N>{
    InlineLoggingNested(InlineLogging item) {
      this.builder = new InlineLoggingBuilder(this, item);
    }
    InlineLoggingBuilder builder;
    public N and() {
      return (N) ZookeeperClusterSpecFluent.this.withLogging(builder.build());
    }
    public N endInlineLogging() {
      return and();
    }
    
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) ZookeeperClusterSpecFluent.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe() {
      return and();
    }
    
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) ZookeeperClusterSpecFluent.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe() {
      return and();
    }
    
  }
  public class JvmOptionsNested<N> extends JvmOptionsFluent<JvmOptionsNested<N>> implements Nested<N>{
    JvmOptionsNested(JvmOptions item) {
      this.builder = new JvmOptionsBuilder(this, item);
    }
    JvmOptionsBuilder builder;
    public N and() {
      return (N) ZookeeperClusterSpecFluent.this.withJvmOptions(builder.build());
    }
    public N endJvmOptions() {
      return and();
    }
    
  }
  public class JmxOptionsNested<N> extends KafkaJmxOptionsFluent<JmxOptionsNested<N>> implements Nested<N>{
    JmxOptionsNested(KafkaJmxOptions item) {
      this.builder = new KafkaJmxOptionsBuilder(this, item);
    }
    KafkaJmxOptionsBuilder builder;
    public N and() {
      return (N) ZookeeperClusterSpecFluent.this.withJmxOptions(builder.build());
    }
    public N endJmxOptions() {
      return and();
    }
    
  }
  public class JmxPrometheusExporterMetricsConfigNested<N> extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsConfigNested<N>> implements Nested<N>{
    JmxPrometheusExporterMetricsConfigNested(JmxPrometheusExporterMetrics item) {
      this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
    }
    JmxPrometheusExporterMetricsBuilder builder;
    public N and() {
      return (N) ZookeeperClusterSpecFluent.this.withMetricsConfig(builder.build());
    }
    public N endJmxPrometheusExporterMetricsConfig() {
      return and();
    }
    
  }
  public class TemplateNested<N> extends ZookeeperClusterTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(ZookeeperClusterTemplate item) {
      this.builder = new ZookeeperClusterTemplateBuilder(this, item);
    }
    ZookeeperClusterTemplateBuilder builder;
    public N and() {
      return (N) ZookeeperClusterSpecFluent.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}