package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaClientAuthenticationOAuthBuilder extends KafkaClientAuthenticationOAuthFluent<KafkaClientAuthenticationOAuthBuilder> implements VisitableBuilder<KafkaClientAuthenticationOAuth,KafkaClientAuthenticationOAuthBuilder>{
  public KafkaClientAuthenticationOAuthBuilder() {
    this(false);
  }
  public KafkaClientAuthenticationOAuthBuilder(Boolean validationEnabled) {
    this(new KafkaClientAuthenticationOAuth(), validationEnabled);
  }
  public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaClientAuthenticationOAuth(), validationEnabled);
  }
  public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent,KafkaClientAuthenticationOAuth instance) {
    this(fluent, instance, false);
  }
  public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuthFluent<?> fluent,KafkaClientAuthenticationOAuth instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaClientAuthenticationOAuth());

    if (instance != null) {
      fluent.withClientId(instance.getClientId());
      fluent.withUsername(instance.getUsername());
      fluent.withScope(instance.getScope());
      fluent.withAudience(instance.getAudience());
      fluent.withTokenEndpointUri(instance.getTokenEndpointUri());
      fluent.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
      fluent.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
      fluent.withHttpRetries(instance.getHttpRetries());
      fluent.withHttpRetryPauseMs(instance.getHttpRetryPauseMs());
      fluent.withClientSecret(instance.getClientSecret());
      fluent.withPasswordSecret(instance.getPasswordSecret());
      fluent.withAccessToken(instance.getAccessToken());
      fluent.withRefreshToken(instance.getRefreshToken());
      fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
      fluent.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
      fluent.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
      fluent.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
      fluent.withEnableMetrics(instance.isEnableMetrics());
      fluent.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuth instance) {
    this(instance,false);
  }
  public KafkaClientAuthenticationOAuthBuilder(KafkaClientAuthenticationOAuth instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaClientAuthenticationOAuth());

    if (instance != null) {
      this.withClientId(instance.getClientId());
      this.withUsername(instance.getUsername());
      this.withScope(instance.getScope());
      this.withAudience(instance.getAudience());
      this.withTokenEndpointUri(instance.getTokenEndpointUri());
      this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
      this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
      this.withHttpRetries(instance.getHttpRetries());
      this.withHttpRetryPauseMs(instance.getHttpRetryPauseMs());
      this.withClientSecret(instance.getClientSecret());
      this.withPasswordSecret(instance.getPasswordSecret());
      this.withAccessToken(instance.getAccessToken());
      this.withRefreshToken(instance.getRefreshToken());
      this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
      this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
      this.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
      this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
      this.withEnableMetrics(instance.isEnableMetrics());
      this.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaClientAuthenticationOAuthFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaClientAuthenticationOAuth build() {
    KafkaClientAuthenticationOAuth buildable = new KafkaClientAuthenticationOAuth();
    buildable.setClientId(fluent.getClientId());
    buildable.setUsername(fluent.getUsername());
    buildable.setScope(fluent.getScope());
    buildable.setAudience(fluent.getAudience());
    buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
    buildable.setConnectTimeoutSeconds(fluent.getConnectTimeoutSeconds());
    buildable.setReadTimeoutSeconds(fluent.getReadTimeoutSeconds());
    buildable.setHttpRetries(fluent.getHttpRetries());
    buildable.setHttpRetryPauseMs(fluent.getHttpRetryPauseMs());
    buildable.setClientSecret(fluent.buildClientSecret());
    buildable.setPasswordSecret(fluent.buildPasswordSecret());
    buildable.setAccessToken(fluent.buildAccessToken());
    buildable.setRefreshToken(fluent.buildRefreshToken());
    buildable.setTlsTrustedCertificates(fluent.buildTlsTrustedCertificates());
    buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
    buildable.setMaxTokenExpirySeconds(fluent.getMaxTokenExpirySeconds());
    buildable.setAccessTokenIsJwt(fluent.isAccessTokenIsJwt());
    buildable.setEnableMetrics(fluent.isEnableMetrics());
    buildable.setIncludeAcceptHeader(fluent.isIncludeAcceptHeader());
    return buildable;
  }
  
}