package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaClientAuthenticationPlainBuilder extends KafkaClientAuthenticationPlainFluent<KafkaClientAuthenticationPlainBuilder> implements VisitableBuilder<KafkaClientAuthenticationPlain,KafkaClientAuthenticationPlainBuilder>{
  public KafkaClientAuthenticationPlainBuilder() {
    this(false);
  }
  public KafkaClientAuthenticationPlainBuilder(Boolean validationEnabled) {
    this(new KafkaClientAuthenticationPlain(), validationEnabled);
  }
  public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaClientAuthenticationPlain(), validationEnabled);
  }
  public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent,KafkaClientAuthenticationPlain instance) {
    this(fluent, instance, false);
  }
  public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlainFluent<?> fluent,KafkaClientAuthenticationPlain instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaClientAuthenticationPlain());

    if (instance != null) {
      fluent.withUsername(instance.getUsername());
      fluent.withPasswordSecret(instance.getPasswordSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlain instance) {
    this(instance,false);
  }
  public KafkaClientAuthenticationPlainBuilder(KafkaClientAuthenticationPlain instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaClientAuthenticationPlain());

    if (instance != null) {
      this.withUsername(instance.getUsername());
      this.withPasswordSecret(instance.getPasswordSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaClientAuthenticationPlainFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaClientAuthenticationPlain build() {
    KafkaClientAuthenticationPlain buildable = new KafkaClientAuthenticationPlain();
    buildable.setUsername(fluent.getUsername());
    buildable.setPasswordSecret(fluent.buildPasswordSecret());
    return buildable;
  }
  
}