package io.strimzi.api.kafka.model.authentication;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.PasswordSecretSource;
import java.lang.Object;
import java.lang.String;
import io.strimzi.api.kafka.model.PasswordSecretSourceFluent;
import io.strimzi.api.kafka.model.PasswordSecretSourceBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaClientAuthenticationPlainFluent<A extends KafkaClientAuthenticationPlainFluent<A>> extends BaseFluent<A>{
  public KafkaClientAuthenticationPlainFluent() {
  }
  public KafkaClientAuthenticationPlainFluent(KafkaClientAuthenticationPlain instance) {
    instance = (instance != null ? instance : new KafkaClientAuthenticationPlain());

    if (instance != null) {
      this.withUsername(instance.getUsername());
      this.withPasswordSecret(instance.getPasswordSecret());
    }
  }
  private String username;
  private PasswordSecretSourceBuilder passwordSecret;
  public String getUsername() {
    return this.username;
  }
  public A withUsername(String username) {
    this.username=username; return (A) this;
  }
  public boolean hasUsername() {
    return this.username != null;
  }
  public PasswordSecretSource buildPasswordSecret() {
    return this.passwordSecret!=null ?this.passwordSecret.build():null;
  }
  public A withPasswordSecret(PasswordSecretSource passwordSecret) {
    _visitables.get("passwordSecret").remove(this.passwordSecret);
    if (passwordSecret!=null){ this.passwordSecret= new PasswordSecretSourceBuilder(passwordSecret); _visitables.get("passwordSecret").add(this.passwordSecret);} else { this.passwordSecret = null; _visitables.get("passwordSecret").remove(this.passwordSecret); } return (A) this;
  }
  public boolean hasPasswordSecret() {
    return this.passwordSecret != null;
  }
  public PasswordSecretNested<A> withNewPasswordSecret() {
    return new PasswordSecretNested(null);
  }
  public PasswordSecretNested<A> withNewPasswordSecretLike(PasswordSecretSource item) {
    return new PasswordSecretNested(item);
  }
  public PasswordSecretNested<A> editPasswordSecret() {
    return withNewPasswordSecretLike(java.util.Optional.ofNullable(buildPasswordSecret()).orElse(null));
  }
  public PasswordSecretNested<A> editOrNewPasswordSecret() {
    return withNewPasswordSecretLike(java.util.Optional.ofNullable(buildPasswordSecret()).orElse(new PasswordSecretSourceBuilder().build()));
  }
  public PasswordSecretNested<A> editOrNewPasswordSecretLike(PasswordSecretSource item) {
    return withNewPasswordSecretLike(java.util.Optional.ofNullable(buildPasswordSecret()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaClientAuthenticationPlainFluent that = (KafkaClientAuthenticationPlainFluent) o;
    if (!java.util.Objects.equals(username, that.username)) return false;

    if (!java.util.Objects.equals(passwordSecret, that.passwordSecret)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(username,  passwordSecret,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (passwordSecret != null) { sb.append("passwordSecret:"); sb.append(passwordSecret); }
    sb.append("}");
    return sb.toString();
  }
  public class PasswordSecretNested<N> extends PasswordSecretSourceFluent<PasswordSecretNested<N>> implements Nested<N>{
    PasswordSecretNested(PasswordSecretSource item) {
      this.builder = new PasswordSecretSourceBuilder(this, item);
    }
    PasswordSecretSourceBuilder builder;
    public N and() {
      return (N) KafkaClientAuthenticationPlainFluent.this.withPasswordSecret(builder.build());
    }
    public N endPasswordSecret() {
      return and();
    }
    
  }
  
}