package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaClientAuthenticationTlsBuilder extends KafkaClientAuthenticationTlsFluent<KafkaClientAuthenticationTlsBuilder> implements VisitableBuilder<KafkaClientAuthenticationTls,KafkaClientAuthenticationTlsBuilder>{
  public KafkaClientAuthenticationTlsBuilder() {
    this(false);
  }
  public KafkaClientAuthenticationTlsBuilder(Boolean validationEnabled) {
    this(new KafkaClientAuthenticationTls(), validationEnabled);
  }
  public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTlsFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTlsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaClientAuthenticationTls(), validationEnabled);
  }
  public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTlsFluent<?> fluent,KafkaClientAuthenticationTls instance) {
    this(fluent, instance, false);
  }
  public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTlsFluent<?> fluent,KafkaClientAuthenticationTls instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaClientAuthenticationTls());

    if (instance != null) {
      fluent.withCertificateAndKey(instance.getCertificateAndKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTls instance) {
    this(instance,false);
  }
  public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTls instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaClientAuthenticationTls());

    if (instance != null) {
      this.withCertificateAndKey(instance.getCertificateAndKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaClientAuthenticationTlsFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaClientAuthenticationTls build() {
    KafkaClientAuthenticationTls buildable = new KafkaClientAuthenticationTls();
    buildable.setCertificateAndKey(fluent.buildCertificateAndKey());
    return buildable;
  }
  
}