package io.strimzi.api.kafka.model.balancing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BrokerCapacityFluent<A extends BrokerCapacityFluent<A>> extends BaseFluent<A>{
  public BrokerCapacityFluent() {
  }
  public BrokerCapacityFluent(BrokerCapacity instance) {
    instance = (instance != null ? instance : new BrokerCapacity());

    if (instance != null) {
      this.withDisk(instance.getDisk());
      this.withCpuUtilization(instance.getCpuUtilization());
      this.withCpu(instance.getCpu());
      this.withInboundNetwork(instance.getInboundNetwork());
      this.withOutboundNetwork(instance.getOutboundNetwork());
      this.withOverrides(instance.getOverrides());
    }
  }
  private String disk;
  private Integer cpuUtilization;
  private String cpu;
  private String inboundNetwork;
  private String outboundNetwork;
  private ArrayList<BrokerCapacityOverrideBuilder> overrides;
  public String getDisk() {
    return this.disk;
  }
  public A withDisk(String disk) {
    this.disk=disk; return (A) this;
  }
  public boolean hasDisk() {
    return this.disk != null;
  }
  public Integer getCpuUtilization() {
    return this.cpuUtilization;
  }
  public A withCpuUtilization(Integer cpuUtilization) {
    this.cpuUtilization=cpuUtilization; return (A) this;
  }
  public boolean hasCpuUtilization() {
    return this.cpuUtilization != null;
  }
  public String getCpu() {
    return this.cpu;
  }
  public A withCpu(String cpu) {
    this.cpu=cpu; return (A) this;
  }
  public boolean hasCpu() {
    return this.cpu != null;
  }
  public String getInboundNetwork() {
    return this.inboundNetwork;
  }
  public A withInboundNetwork(String inboundNetwork) {
    this.inboundNetwork=inboundNetwork; return (A) this;
  }
  public boolean hasInboundNetwork() {
    return this.inboundNetwork != null;
  }
  public String getOutboundNetwork() {
    return this.outboundNetwork;
  }
  public A withOutboundNetwork(String outboundNetwork) {
    this.outboundNetwork=outboundNetwork; return (A) this;
  }
  public boolean hasOutboundNetwork() {
    return this.outboundNetwork != null;
  }
  public A addToOverrides(int index,BrokerCapacityOverride item) {
    if (this.overrides == null) {this.overrides = new ArrayList<BrokerCapacityOverrideBuilder>();}
    BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);
    if (index < 0 || index >= overrides.size()) { _visitables.get("overrides").add(builder); overrides.add(builder); } else { _visitables.get("overrides").add(index, builder); overrides.add(index, builder);}
    return (A)this;
  }
  public A setToOverrides(int index,BrokerCapacityOverride item) {
    if (this.overrides == null) {this.overrides = new ArrayList<BrokerCapacityOverrideBuilder>();}
    BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);
    if (index < 0 || index >= overrides.size()) { _visitables.get("overrides").add(builder); overrides.add(builder); } else { _visitables.get("overrides").set(index, builder); overrides.set(index, builder);}
    return (A)this;
  }
  public A addToOverrides(io.strimzi.api.kafka.model.balancing.BrokerCapacityOverride... items) {
    if (this.overrides == null) {this.overrides = new ArrayList<BrokerCapacityOverrideBuilder>();}
    for (BrokerCapacityOverride item : items) {BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
  }
  public A addAllToOverrides(Collection<BrokerCapacityOverride> items) {
    if (this.overrides == null) {this.overrides = new ArrayList<BrokerCapacityOverrideBuilder>();}
    for (BrokerCapacityOverride item : items) {BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
  }
  public A removeFromOverrides(io.strimzi.api.kafka.model.balancing.BrokerCapacityOverride... items) {
    if (this.overrides == null) return (A)this;
    for (BrokerCapacityOverride item : items) {BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);_visitables.get("overrides").remove(builder); this.overrides.remove(builder);} return (A)this;
  }
  public A removeAllFromOverrides(Collection<BrokerCapacityOverride> items) {
    if (this.overrides == null) return (A)this;
    for (BrokerCapacityOverride item : items) {BrokerCapacityOverrideBuilder builder = new BrokerCapacityOverrideBuilder(item);_visitables.get("overrides").remove(builder); this.overrides.remove(builder);} return (A)this;
  }
  public A removeMatchingFromOverrides(Predicate<BrokerCapacityOverrideBuilder> predicate) {
    if (overrides == null) return (A) this;
    final Iterator<BrokerCapacityOverrideBuilder> each = overrides.iterator();
    final List visitables = _visitables.get("overrides");
    while (each.hasNext()) {
      BrokerCapacityOverrideBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<BrokerCapacityOverride> buildOverrides() {
    return overrides != null ? build(overrides) : null;
  }
  public BrokerCapacityOverride buildOverride(int index) {
    return this.overrides.get(index).build();
  }
  public BrokerCapacityOverride buildFirstOverride() {
    return this.overrides.get(0).build();
  }
  public BrokerCapacityOverride buildLastOverride() {
    return this.overrides.get(overrides.size() - 1).build();
  }
  public BrokerCapacityOverride buildMatchingOverride(Predicate<BrokerCapacityOverrideBuilder> predicate) {
    for (BrokerCapacityOverrideBuilder item: overrides) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingOverride(Predicate<BrokerCapacityOverrideBuilder> predicate) {
    for (BrokerCapacityOverrideBuilder item: overrides) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOverrides(List<BrokerCapacityOverride> overrides) {
    if (this.overrides != null) { _visitables.get("overrides").clear();}
    if (overrides != null) {this.overrides = new ArrayList(); for (BrokerCapacityOverride item : overrides){this.addToOverrides(item);}} else { this.overrides = null;} return (A) this;
  }
  public A withOverrides(io.strimzi.api.kafka.model.balancing.BrokerCapacityOverride... overrides) {
    if (this.overrides != null) {this.overrides.clear(); _visitables.remove("overrides"); }
    if (overrides != null) {for (BrokerCapacityOverride item :overrides){ this.addToOverrides(item);}} return (A) this;
  }
  public boolean hasOverrides() {
    return overrides != null && !overrides.isEmpty();
  }
  public OverridesNested<A> addNewOverride() {
    return new OverridesNested(-1, null);
  }
  public OverridesNested<A> addNewOverrideLike(BrokerCapacityOverride item) {
    return new OverridesNested(-1, item);
  }
  public OverridesNested<A> setNewOverrideLike(int index,BrokerCapacityOverride item) {
    return new OverridesNested(index, item);
  }
  public OverridesNested<A> editOverride(int index) {
    if (overrides.size() <= index) throw new RuntimeException("Can't edit overrides. Index exceeds size.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  public OverridesNested<A> editFirstOverride() {
    if (overrides.size() == 0) throw new RuntimeException("Can't edit first overrides. The list is empty.");
    return setNewOverrideLike(0, buildOverride(0));
  }
  public OverridesNested<A> editLastOverride() {
    int index = overrides.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last overrides. The list is empty.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  public OverridesNested<A> editMatchingOverride(Predicate<BrokerCapacityOverrideBuilder> predicate) {
    int index = -1;
    for (int i=0;i<overrides.size();i++) { 
    if (predicate.test(overrides.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching overrides. No match found.");
    return setNewOverrideLike(index, buildOverride(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BrokerCapacityFluent that = (BrokerCapacityFluent) o;
    if (!java.util.Objects.equals(disk, that.disk)) return false;

    if (!java.util.Objects.equals(cpuUtilization, that.cpuUtilization)) return false;

    if (!java.util.Objects.equals(cpu, that.cpu)) return false;

    if (!java.util.Objects.equals(inboundNetwork, that.inboundNetwork)) return false;

    if (!java.util.Objects.equals(outboundNetwork, that.outboundNetwork)) return false;

    if (!java.util.Objects.equals(overrides, that.overrides)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(disk,  cpuUtilization,  cpu,  inboundNetwork,  outboundNetwork,  overrides,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (disk != null) { sb.append("disk:"); sb.append(disk + ","); }
    if (cpuUtilization != null) { sb.append("cpuUtilization:"); sb.append(cpuUtilization + ","); }
    if (cpu != null) { sb.append("cpu:"); sb.append(cpu + ","); }
    if (inboundNetwork != null) { sb.append("inboundNetwork:"); sb.append(inboundNetwork + ","); }
    if (outboundNetwork != null) { sb.append("outboundNetwork:"); sb.append(outboundNetwork + ","); }
    if (overrides != null && !overrides.isEmpty()) { sb.append("overrides:"); sb.append(overrides); }
    sb.append("}");
    return sb.toString();
  }
  public class OverridesNested<N> extends BrokerCapacityOverrideFluent<OverridesNested<N>> implements Nested<N>{
    OverridesNested(int index,BrokerCapacityOverride item) {
      this.index = index;
      this.builder = new BrokerCapacityOverrideBuilder(this, item);
    }
    BrokerCapacityOverrideBuilder builder;
    int index;
    public N and() {
      return (N) BrokerCapacityFluent.this.setToOverrides(index,builder.build());
    }
    public N endOverride() {
      return and();
    }
    
  }
  
}