package io.strimzi.api.kafka.model.balancing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerCapacityOverrideBuilder extends BrokerCapacityOverrideFluent<BrokerCapacityOverrideBuilder> implements VisitableBuilder<BrokerCapacityOverride,BrokerCapacityOverrideBuilder>{
  public BrokerCapacityOverrideBuilder() {
    this(false);
  }
  public BrokerCapacityOverrideBuilder(Boolean validationEnabled) {
    this(new BrokerCapacityOverride(), validationEnabled);
  }
  public BrokerCapacityOverrideBuilder(BrokerCapacityOverrideFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerCapacityOverrideBuilder(BrokerCapacityOverrideFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BrokerCapacityOverride(), validationEnabled);
  }
  public BrokerCapacityOverrideBuilder(BrokerCapacityOverrideFluent<?> fluent,BrokerCapacityOverride instance) {
    this(fluent, instance, false);
  }
  public BrokerCapacityOverrideBuilder(BrokerCapacityOverrideFluent<?> fluent,BrokerCapacityOverride instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BrokerCapacityOverride());

    if (instance != null) {
      fluent.withBrokers(instance.getBrokers());
      fluent.withCpu(instance.getCpu());
      fluent.withInboundNetwork(instance.getInboundNetwork());
      fluent.withOutboundNetwork(instance.getOutboundNetwork());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BrokerCapacityOverrideBuilder(BrokerCapacityOverride instance) {
    this(instance,false);
  }
  public BrokerCapacityOverrideBuilder(BrokerCapacityOverride instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BrokerCapacityOverride());

    if (instance != null) {
      this.withBrokers(instance.getBrokers());
      this.withCpu(instance.getCpu());
      this.withInboundNetwork(instance.getInboundNetwork());
      this.withOutboundNetwork(instance.getOutboundNetwork());
    }
    this.validationEnabled = validationEnabled; 
  }
  BrokerCapacityOverrideFluent<?> fluent;
  Boolean validationEnabled;
  public BrokerCapacityOverride build() {
    BrokerCapacityOverride buildable = new BrokerCapacityOverride();
    buildable.setBrokers(fluent.getBrokers());
    buildable.setCpu(fluent.getCpu());
    buildable.setInboundNetwork(fluent.getInboundNetwork());
    buildable.setOutboundNetwork(fluent.getOutboundNetwork());
    return buildable;
  }
  
}