package io.strimzi.api.kafka.model.balancing;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BrokerCapacityOverrideFluent<A extends BrokerCapacityOverrideFluent<A>> extends BaseFluent<A>{
  public BrokerCapacityOverrideFluent() {
  }
  public BrokerCapacityOverrideFluent(BrokerCapacityOverride instance) {
    instance = (instance != null ? instance : new BrokerCapacityOverride());

    if (instance != null) {
      this.withBrokers(instance.getBrokers());
      this.withCpu(instance.getCpu());
      this.withInboundNetwork(instance.getInboundNetwork());
      this.withOutboundNetwork(instance.getOutboundNetwork());
    }
  }
  private List<Integer> brokers;
  private String cpu;
  private String inboundNetwork;
  private String outboundNetwork;
  public A addToBrokers(int index,Integer item) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    this.brokers.add(index, item);
    return (A)this;
  }
  public A setToBrokers(int index,Integer item) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    this.brokers.set(index, item); return (A)this;
  }
  public A addToBrokers(java.lang.Integer... items) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    for (Integer item : items) {this.brokers.add(item);} return (A)this;
  }
  public A addAllToBrokers(Collection<Integer> items) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    for (Integer item : items) {this.brokers.add(item);} return (A)this;
  }
  public A removeFromBrokers(java.lang.Integer... items) {
    if (this.brokers == null) return (A)this;
    for (Integer item : items) { this.brokers.remove(item);} return (A)this;
  }
  public A removeAllFromBrokers(Collection<Integer> items) {
    if (this.brokers == null) return (A)this;
    for (Integer item : items) { this.brokers.remove(item);} return (A)this;
  }
  public List<Integer> getBrokers() {
    return this.brokers;
  }
  public Integer getBroker(int index) {
    return this.brokers.get(index);
  }
  public Integer getFirstBroker() {
    return this.brokers.get(0);
  }
  public Integer getLastBroker() {
    return this.brokers.get(brokers.size() - 1);
  }
  public Integer getMatchingBroker(Predicate<Integer> predicate) {
    for (Integer item: brokers) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingBroker(Predicate<Integer> predicate) {
    for (Integer item: brokers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBrokers(List<Integer> brokers) {
    if (brokers != null) {this.brokers = new ArrayList(); for (Integer item : brokers){this.addToBrokers(item);}} else { this.brokers = null;} return (A) this;
  }
  public A withBrokers(java.lang.Integer... brokers) {
    if (this.brokers != null) {this.brokers.clear(); _visitables.remove("brokers"); }
    if (brokers != null) {for (Integer item :brokers){ this.addToBrokers(item);}} return (A) this;
  }
  public boolean hasBrokers() {
    return brokers != null && !brokers.isEmpty();
  }
  public String getCpu() {
    return this.cpu;
  }
  public A withCpu(String cpu) {
    this.cpu=cpu; return (A) this;
  }
  public boolean hasCpu() {
    return this.cpu != null;
  }
  public String getInboundNetwork() {
    return this.inboundNetwork;
  }
  public A withInboundNetwork(String inboundNetwork) {
    this.inboundNetwork=inboundNetwork; return (A) this;
  }
  public boolean hasInboundNetwork() {
    return this.inboundNetwork != null;
  }
  public String getOutboundNetwork() {
    return this.outboundNetwork;
  }
  public A withOutboundNetwork(String outboundNetwork) {
    this.outboundNetwork=outboundNetwork; return (A) this;
  }
  public boolean hasOutboundNetwork() {
    return this.outboundNetwork != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BrokerCapacityOverrideFluent that = (BrokerCapacityOverrideFluent) o;
    if (!java.util.Objects.equals(brokers, that.brokers)) return false;

    if (!java.util.Objects.equals(cpu, that.cpu)) return false;

    if (!java.util.Objects.equals(inboundNetwork, that.inboundNetwork)) return false;

    if (!java.util.Objects.equals(outboundNetwork, that.outboundNetwork)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(brokers,  cpu,  inboundNetwork,  outboundNetwork,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (brokers != null && !brokers.isEmpty()) { sb.append("brokers:"); sb.append(brokers + ","); }
    if (cpu != null) { sb.append("cpu:"); sb.append(cpu + ","); }
    if (inboundNetwork != null) { sb.append("inboundNetwork:"); sb.append(inboundNetwork + ","); }
    if (outboundNetwork != null) { sb.append("outboundNetwork:"); sb.append(outboundNetwork); }
    sb.append("}");
    return sb.toString();
  }
  
}