/*
 * Copyright Strimzi authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */
package io.strimzi.api.kafka.model.connect;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.Constants;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.sundr.builder.annotations.Buildable;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Representation a connector plugin available in the Kafka Connect deployment
 */
@Buildable(
        editableEnabled = false,
        builderPackage = Constants.FABRIC8_KUBERNETES_API
)
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder({ "connectorClass", "type", "version" })
@EqualsAndHashCode
public class ConnectorPlugin implements Serializable, UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;

    private String connectorClass;
    private String type;
    private String version;
    private Map<String, Object> additionalProperties = new HashMap<>(0);

    @Description("The class of the connector plugin.")
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    @JsonProperty("class")
    public String getConnectorClass() {
        return connectorClass;
    }

    public void setConnectorClass(String connectorClass) {
        this.connectorClass = connectorClass;
    }

    @Description("The type of the connector plugin. " +
            "The available types are `sink` and `source`.")
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Description("The version of the connector plugin.")
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}

