package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConnectorPluginBuilder extends ConnectorPluginFluent<ConnectorPluginBuilder> implements VisitableBuilder<ConnectorPlugin,ConnectorPluginBuilder>{
  public ConnectorPluginBuilder() {
    this(false);
  }
  public ConnectorPluginBuilder(Boolean validationEnabled) {
    this(new ConnectorPlugin(), validationEnabled);
  }
  public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent) {
    this(fluent, false);
  }
  public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConnectorPlugin(), validationEnabled);
  }
  public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent,ConnectorPlugin instance) {
    this(fluent, instance, false);
  }
  public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent,ConnectorPlugin instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConnectorPlugin());

    if (instance != null) {
      fluent.withConnectorClass(instance.getConnectorClass());
      fluent.withType(instance.getType());
      fluent.withVersion(instance.getVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConnectorPluginBuilder(ConnectorPlugin instance) {
    this(instance,false);
  }
  public ConnectorPluginBuilder(ConnectorPlugin instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConnectorPlugin());

    if (instance != null) {
      this.withConnectorClass(instance.getConnectorClass());
      this.withType(instance.getType());
      this.withVersion(instance.getVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConnectorPluginFluent<?> fluent;
  Boolean validationEnabled;
  public ConnectorPlugin build() {
    ConnectorPlugin buildable = new ConnectorPlugin();
    buildable.setConnectorClass(fluent.getConnectorClass());
    buildable.setType(fluent.getType());
    buildable.setVersion(fluent.getVersion());
    return buildable;
  }
  
}