package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildBuilder extends BuildFluent<BuildBuilder> implements VisitableBuilder<Build,BuildBuilder>{
  public BuildBuilder() {
    this(false);
  }
  public BuildBuilder(Boolean validationEnabled) {
    this(new Build(), validationEnabled);
  }
  public BuildBuilder(BuildFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildBuilder(BuildFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Build(), validationEnabled);
  }
  public BuildBuilder(BuildFluent<?> fluent,Build instance) {
    this(fluent, instance, false);
  }
  public BuildBuilder(BuildFluent<?> fluent,Build instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Build());

    if (instance != null) {
      fluent.withOutput(instance.getOutput());
      fluent.withPlugins(instance.getPlugins());
      fluent.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildBuilder(Build instance) {
    this(instance,false);
  }
  public BuildBuilder(Build instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Build());

    if (instance != null) {
      this.withOutput(instance.getOutput());
      this.withPlugins(instance.getPlugins());
      this.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildFluent<?> fluent;
  Boolean validationEnabled;
  public Build build() {
    Build buildable = new Build();
    buildable.setOutput(fluent.buildOutput());
    buildable.setPlugins(fluent.buildPlugins());
    buildable.setResources(fluent.getResources());
    return buildable;
  }
  
}