package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DockerOutputBuilder extends DockerOutputFluent<DockerOutputBuilder> implements VisitableBuilder<DockerOutput,DockerOutputBuilder>{
  public DockerOutputBuilder() {
    this(false);
  }
  public DockerOutputBuilder(Boolean validationEnabled) {
    this(new DockerOutput(), validationEnabled);
  }
  public DockerOutputBuilder(DockerOutputFluent<?> fluent) {
    this(fluent, false);
  }
  public DockerOutputBuilder(DockerOutputFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DockerOutput(), validationEnabled);
  }
  public DockerOutputBuilder(DockerOutputFluent<?> fluent,DockerOutput instance) {
    this(fluent, instance, false);
  }
  public DockerOutputBuilder(DockerOutputFluent<?> fluent,DockerOutput instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DockerOutput());

    if (instance != null) {
      fluent.withImage(instance.getImage());
      fluent.withPushSecret(instance.getPushSecret());
      fluent.withAdditionalKanikoOptions(instance.getAdditionalKanikoOptions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DockerOutputBuilder(DockerOutput instance) {
    this(instance,false);
  }
  public DockerOutputBuilder(DockerOutput instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DockerOutput());

    if (instance != null) {
      this.withImage(instance.getImage());
      this.withPushSecret(instance.getPushSecret());
      this.withAdditionalKanikoOptions(instance.getAdditionalKanikoOptions());
    }
    this.validationEnabled = validationEnabled; 
  }
  DockerOutputFluent<?> fluent;
  Boolean validationEnabled;
  public DockerOutput build() {
    DockerOutput buildable = new DockerOutput();
    buildable.setImage(fluent.getImage());
    buildable.setPushSecret(fluent.getPushSecret());
    buildable.setAdditionalKanikoOptions(fluent.getAdditionalKanikoOptions());
    return buildable;
  }
  
}