package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamOutputBuilder extends ImageStreamOutputFluent<ImageStreamOutputBuilder> implements VisitableBuilder<ImageStreamOutput,ImageStreamOutputBuilder>{
  public ImageStreamOutputBuilder() {
    this(false);
  }
  public ImageStreamOutputBuilder(Boolean validationEnabled) {
    this(new ImageStreamOutput(), validationEnabled);
  }
  public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamOutput(), validationEnabled);
  }
  public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent,ImageStreamOutput instance) {
    this(fluent, instance, false);
  }
  public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent,ImageStreamOutput instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageStreamOutput());

    if (instance != null) {
      fluent.withImage(instance.getImage());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamOutputBuilder(ImageStreamOutput instance) {
    this(instance,false);
  }
  public ImageStreamOutputBuilder(ImageStreamOutput instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageStreamOutput());

    if (instance != null) {
      this.withImage(instance.getImage());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStreamOutputFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamOutput build() {
    ImageStreamOutput buildable = new ImageStreamOutput();
    buildable.setImage(fluent.getImage());
    return buildable;
  }
  
}