package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JarArtifactBuilder extends JarArtifactFluent<JarArtifactBuilder> implements VisitableBuilder<JarArtifact,JarArtifactBuilder>{
  public JarArtifactBuilder() {
    this(false);
  }
  public JarArtifactBuilder(Boolean validationEnabled) {
    this(new JarArtifact(), validationEnabled);
  }
  public JarArtifactBuilder(JarArtifactFluent<?> fluent) {
    this(fluent, false);
  }
  public JarArtifactBuilder(JarArtifactFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JarArtifact(), validationEnabled);
  }
  public JarArtifactBuilder(JarArtifactFluent<?> fluent,JarArtifact instance) {
    this(fluent, instance, false);
  }
  public JarArtifactBuilder(JarArtifactFluent<?> fluent,JarArtifact instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new JarArtifact());

    if (instance != null) {
      fluent.withUrl(instance.getUrl());
      fluent.withSha512sum(instance.getSha512sum());
      fluent.withInsecure(instance.getInsecure());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JarArtifactBuilder(JarArtifact instance) {
    this(instance,false);
  }
  public JarArtifactBuilder(JarArtifact instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new JarArtifact());

    if (instance != null) {
      this.withUrl(instance.getUrl());
      this.withSha512sum(instance.getSha512sum());
      this.withInsecure(instance.getInsecure());
    }
    this.validationEnabled = validationEnabled; 
  }
  JarArtifactFluent<?> fluent;
  Boolean validationEnabled;
  public JarArtifact build() {
    JarArtifact buildable = new JarArtifact();
    buildable.setUrl(fluent.getUrl());
    buildable.setSha512sum(fluent.getSha512sum());
    buildable.setInsecure(fluent.getInsecure());
    return buildable;
  }
  
}