package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MavenArtifactBuilder extends MavenArtifactFluent<MavenArtifactBuilder> implements VisitableBuilder<MavenArtifact,MavenArtifactBuilder>{
  public MavenArtifactBuilder() {
    this(false);
  }
  public MavenArtifactBuilder(Boolean validationEnabled) {
    this(new MavenArtifact(), validationEnabled);
  }
  public MavenArtifactBuilder(MavenArtifactFluent<?> fluent) {
    this(fluent, false);
  }
  public MavenArtifactBuilder(MavenArtifactFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MavenArtifact(), validationEnabled);
  }
  public MavenArtifactBuilder(MavenArtifactFluent<?> fluent,MavenArtifact instance) {
    this(fluent, instance, false);
  }
  public MavenArtifactBuilder(MavenArtifactFluent<?> fluent,MavenArtifact instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MavenArtifact());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withArtifact(instance.getArtifact());
      fluent.withVersion(instance.getVersion());
      fluent.withRepository(instance.getRepository());
      fluent.withInsecure(instance.getInsecure());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MavenArtifactBuilder(MavenArtifact instance) {
    this(instance,false);
  }
  public MavenArtifactBuilder(MavenArtifact instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MavenArtifact());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withArtifact(instance.getArtifact());
      this.withVersion(instance.getVersion());
      this.withRepository(instance.getRepository());
      this.withInsecure(instance.getInsecure());
    }
    this.validationEnabled = validationEnabled; 
  }
  MavenArtifactFluent<?> fluent;
  Boolean validationEnabled;
  public MavenArtifact build() {
    MavenArtifact buildable = new MavenArtifact();
    buildable.setGroup(fluent.getGroup());
    buildable.setArtifact(fluent.getArtifact());
    buildable.setVersion(fluent.getVersion());
    buildable.setRepository(fluent.getRepository());
    buildable.setInsecure(fluent.getInsecure());
    return buildable;
  }
  
}