package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PluginBuilder extends PluginFluent<PluginBuilder> implements VisitableBuilder<Plugin,PluginBuilder>{
  public PluginBuilder() {
    this(false);
  }
  public PluginBuilder(Boolean validationEnabled) {
    this(new Plugin(), validationEnabled);
  }
  public PluginBuilder(PluginFluent<?> fluent) {
    this(fluent, false);
  }
  public PluginBuilder(PluginFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Plugin(), validationEnabled);
  }
  public PluginBuilder(PluginFluent<?> fluent,Plugin instance) {
    this(fluent, instance, false);
  }
  public PluginBuilder(PluginFluent<?> fluent,Plugin instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Plugin());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withArtifacts(instance.getArtifacts());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PluginBuilder(Plugin instance) {
    this(instance,false);
  }
  public PluginBuilder(Plugin instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Plugin());

    if (instance != null) {
      this.withName(instance.getName());
      this.withArtifacts(instance.getArtifacts());
    }
    this.validationEnabled = validationEnabled; 
  }
  PluginFluent<?> fluent;
  Boolean validationEnabled;
  public Plugin build() {
    Plugin buildable = new Plugin();
    buildable.setName(fluent.getName());
    buildable.setArtifacts(fluent.buildArtifacts());
    return buildable;
  }
  
}