package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaListenerAuthenticationCustomBuilder extends KafkaListenerAuthenticationCustomFluent<KafkaListenerAuthenticationCustomBuilder> implements VisitableBuilder<KafkaListenerAuthenticationCustom,KafkaListenerAuthenticationCustomBuilder>{
  public KafkaListenerAuthenticationCustomBuilder() {
    this(false);
  }
  public KafkaListenerAuthenticationCustomBuilder(Boolean validationEnabled) {
    this(new KafkaListenerAuthenticationCustom(), validationEnabled);
  }
  public KafkaListenerAuthenticationCustomBuilder(KafkaListenerAuthenticationCustomFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaListenerAuthenticationCustomBuilder(KafkaListenerAuthenticationCustomFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaListenerAuthenticationCustom(), validationEnabled);
  }
  public KafkaListenerAuthenticationCustomBuilder(KafkaListenerAuthenticationCustomFluent<?> fluent,KafkaListenerAuthenticationCustom instance) {
    this(fluent, instance, false);
  }
  public KafkaListenerAuthenticationCustomBuilder(KafkaListenerAuthenticationCustomFluent<?> fluent,KafkaListenerAuthenticationCustom instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaListenerAuthenticationCustom());

    if (instance != null) {
      fluent.withListenerConfig(instance.getListenerConfig());
      fluent.withSasl(instance.isSasl());
      fluent.withSecrets(instance.getSecrets());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaListenerAuthenticationCustomBuilder(KafkaListenerAuthenticationCustom instance) {
    this(instance,false);
  }
  public KafkaListenerAuthenticationCustomBuilder(KafkaListenerAuthenticationCustom instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaListenerAuthenticationCustom());

    if (instance != null) {
      this.withListenerConfig(instance.getListenerConfig());
      this.withSasl(instance.isSasl());
      this.withSecrets(instance.getSecrets());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaListenerAuthenticationCustomFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaListenerAuthenticationCustom build() {
    KafkaListenerAuthenticationCustom buildable = new KafkaListenerAuthenticationCustom();
    buildable.setListenerConfig(fluent.getListenerConfig());
    buildable.setSasl(fluent.isSasl());
    buildable.setSecrets(fluent.buildSecrets());
    return buildable;
  }
  
}