package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GenericKafkaListenerBuilder extends GenericKafkaListenerFluent<GenericKafkaListenerBuilder> implements VisitableBuilder<GenericKafkaListener,GenericKafkaListenerBuilder>{
  public GenericKafkaListenerBuilder() {
    this(false);
  }
  public GenericKafkaListenerBuilder(Boolean validationEnabled) {
    this(new GenericKafkaListener(), validationEnabled);
  }
  public GenericKafkaListenerBuilder(GenericKafkaListenerFluent<?> fluent) {
    this(fluent, false);
  }
  public GenericKafkaListenerBuilder(GenericKafkaListenerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GenericKafkaListener(), validationEnabled);
  }
  public GenericKafkaListenerBuilder(GenericKafkaListenerFluent<?> fluent,GenericKafkaListener instance) {
    this(fluent, instance, false);
  }
  public GenericKafkaListenerBuilder(GenericKafkaListenerFluent<?> fluent,GenericKafkaListener instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GenericKafkaListener());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withPort(instance.getPort());
      fluent.withType(instance.getType());
      fluent.withTls(instance.isTls());
      fluent.withAuth(instance.getAuth());
      fluent.withConfiguration(instance.getConfiguration());
      fluent.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GenericKafkaListenerBuilder(GenericKafkaListener instance) {
    this(instance,false);
  }
  public GenericKafkaListenerBuilder(GenericKafkaListener instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GenericKafkaListener());

    if (instance != null) {
      this.withName(instance.getName());
      this.withPort(instance.getPort());
      this.withType(instance.getType());
      this.withTls(instance.isTls());
      this.withAuth(instance.getAuth());
      this.withConfiguration(instance.getConfiguration());
      this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
    }
    this.validationEnabled = validationEnabled; 
  }
  GenericKafkaListenerFluent<?> fluent;
  Boolean validationEnabled;
  public GenericKafkaListener build() {
    GenericKafkaListener buildable = new GenericKafkaListener();
    buildable.setName(fluent.getName());
    buildable.setPort(fluent.getPort());
    buildable.setType(fluent.getType());
    buildable.setTls(fluent.isTls());
    buildable.setAuth(fluent.buildAuth());
    buildable.setConfiguration(fluent.buildConfiguration());
    buildable.setNetworkPolicyPeers(fluent.getNetworkPolicyPeers());
    return buildable;
  }
  
}