package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GenericKafkaListenerConfigurationBootstrapBuilder extends GenericKafkaListenerConfigurationBootstrapFluent<GenericKafkaListenerConfigurationBootstrapBuilder> implements VisitableBuilder<GenericKafkaListenerConfigurationBootstrap,GenericKafkaListenerConfigurationBootstrapBuilder>{
  public GenericKafkaListenerConfigurationBootstrapBuilder() {
    this(false);
  }
  public GenericKafkaListenerConfigurationBootstrapBuilder(Boolean validationEnabled) {
    this(new GenericKafkaListenerConfigurationBootstrap(), validationEnabled);
  }
  public GenericKafkaListenerConfigurationBootstrapBuilder(GenericKafkaListenerConfigurationBootstrapFluent<?> fluent) {
    this(fluent, false);
  }
  public GenericKafkaListenerConfigurationBootstrapBuilder(GenericKafkaListenerConfigurationBootstrapFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GenericKafkaListenerConfigurationBootstrap(), validationEnabled);
  }
  public GenericKafkaListenerConfigurationBootstrapBuilder(GenericKafkaListenerConfigurationBootstrapFluent<?> fluent,GenericKafkaListenerConfigurationBootstrap instance) {
    this(fluent, instance, false);
  }
  public GenericKafkaListenerConfigurationBootstrapBuilder(GenericKafkaListenerConfigurationBootstrapFluent<?> fluent,GenericKafkaListenerConfigurationBootstrap instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GenericKafkaListenerConfigurationBootstrap());

    if (instance != null) {
      fluent.withAlternativeNames(instance.getAlternativeNames());
      fluent.withHost(instance.getHost());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withLabels(instance.getLabels());
      fluent.withNodePort(instance.getNodePort());
      fluent.withLoadBalancerIP(instance.getLoadBalancerIP());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GenericKafkaListenerConfigurationBootstrapBuilder(GenericKafkaListenerConfigurationBootstrap instance) {
    this(instance,false);
  }
  public GenericKafkaListenerConfigurationBootstrapBuilder(GenericKafkaListenerConfigurationBootstrap instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GenericKafkaListenerConfigurationBootstrap());

    if (instance != null) {
      this.withAlternativeNames(instance.getAlternativeNames());
      this.withHost(instance.getHost());
      this.withAnnotations(instance.getAnnotations());
      this.withLabels(instance.getLabels());
      this.withNodePort(instance.getNodePort());
      this.withLoadBalancerIP(instance.getLoadBalancerIP());
    }
    this.validationEnabled = validationEnabled; 
  }
  GenericKafkaListenerConfigurationBootstrapFluent<?> fluent;
  Boolean validationEnabled;
  public GenericKafkaListenerConfigurationBootstrap build() {
    GenericKafkaListenerConfigurationBootstrap buildable = new GenericKafkaListenerConfigurationBootstrap();
    buildable.setAlternativeNames(fluent.getAlternativeNames());
    buildable.setHost(fluent.getHost());
    buildable.setAnnotations(fluent.getAnnotations());
    buildable.setLabels(fluent.getLabels());
    buildable.setNodePort(fluent.getNodePort());
    buildable.setLoadBalancerIP(fluent.getLoadBalancerIP());
    return buildable;
  }
  
}