package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GenericKafkaListenerConfigurationBrokerBuilder extends GenericKafkaListenerConfigurationBrokerFluent<GenericKafkaListenerConfigurationBrokerBuilder> implements VisitableBuilder<GenericKafkaListenerConfigurationBroker,GenericKafkaListenerConfigurationBrokerBuilder>{
  public GenericKafkaListenerConfigurationBrokerBuilder() {
    this(false);
  }
  public GenericKafkaListenerConfigurationBrokerBuilder(Boolean validationEnabled) {
    this(new GenericKafkaListenerConfigurationBroker(), validationEnabled);
  }
  public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBrokerFluent<?> fluent) {
    this(fluent, false);
  }
  public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBrokerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GenericKafkaListenerConfigurationBroker(), validationEnabled);
  }
  public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBrokerFluent<?> fluent,GenericKafkaListenerConfigurationBroker instance) {
    this(fluent, instance, false);
  }
  public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBrokerFluent<?> fluent,GenericKafkaListenerConfigurationBroker instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GenericKafkaListenerConfigurationBroker());

    if (instance != null) {
      fluent.withBroker(instance.getBroker());
      fluent.withAdvertisedHost(instance.getAdvertisedHost());
      fluent.withAdvertisedPort(instance.getAdvertisedPort());
      fluent.withHost(instance.getHost());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withLabels(instance.getLabels());
      fluent.withNodePort(instance.getNodePort());
      fluent.withLoadBalancerIP(instance.getLoadBalancerIP());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBroker instance) {
    this(instance,false);
  }
  public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBroker instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GenericKafkaListenerConfigurationBroker());

    if (instance != null) {
      this.withBroker(instance.getBroker());
      this.withAdvertisedHost(instance.getAdvertisedHost());
      this.withAdvertisedPort(instance.getAdvertisedPort());
      this.withHost(instance.getHost());
      this.withAnnotations(instance.getAnnotations());
      this.withLabels(instance.getLabels());
      this.withNodePort(instance.getNodePort());
      this.withLoadBalancerIP(instance.getLoadBalancerIP());
    }
    this.validationEnabled = validationEnabled; 
  }
  GenericKafkaListenerConfigurationBrokerFluent<?> fluent;
  Boolean validationEnabled;
  public GenericKafkaListenerConfigurationBroker build() {
    GenericKafkaListenerConfigurationBroker buildable = new GenericKafkaListenerConfigurationBroker();
    buildable.setBroker(fluent.getBroker());
    buildable.setAdvertisedHost(fluent.getAdvertisedHost());
    buildable.setAdvertisedPort(fluent.getAdvertisedPort());
    buildable.setHost(fluent.getHost());
    buildable.setAnnotations(fluent.getAnnotations());
    buildable.setLabels(fluent.getLabels());
    buildable.setNodePort(fluent.getNodePort());
    buildable.setLoadBalancerIP(fluent.getLoadBalancerIP());
    return buildable;
  }
  
}