package io.strimzi.api.kafka.model.listener.arraylistener;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GenericKafkaListenerConfigurationBrokerFluent<A extends GenericKafkaListenerConfigurationBrokerFluent<A>> extends BaseFluent<A>{
  public GenericKafkaListenerConfigurationBrokerFluent() {
  }
  public GenericKafkaListenerConfigurationBrokerFluent(GenericKafkaListenerConfigurationBroker instance) {
    instance = (instance != null ? instance : new GenericKafkaListenerConfigurationBroker());

    if (instance != null) {
      this.withBroker(instance.getBroker());
      this.withAdvertisedHost(instance.getAdvertisedHost());
      this.withAdvertisedPort(instance.getAdvertisedPort());
      this.withHost(instance.getHost());
      this.withAnnotations(instance.getAnnotations());
      this.withLabels(instance.getLabels());
      this.withNodePort(instance.getNodePort());
      this.withLoadBalancerIP(instance.getLoadBalancerIP());
    }
  }
  private Integer broker;
  private String advertisedHost;
  private Integer advertisedPort;
  private String host;
  private Map<String,String> annotations;
  private Map<String,String> labels;
  private Integer nodePort;
  private String loadBalancerIP;
  public Integer getBroker() {
    return this.broker;
  }
  public A withBroker(Integer broker) {
    this.broker=broker; return (A) this;
  }
  public boolean hasBroker() {
    return this.broker != null;
  }
  public String getAdvertisedHost() {
    return this.advertisedHost;
  }
  public A withAdvertisedHost(String advertisedHost) {
    this.advertisedHost=advertisedHost; return (A) this;
  }
  public boolean hasAdvertisedHost() {
    return this.advertisedHost != null;
  }
  public Integer getAdvertisedPort() {
    return this.advertisedPort;
  }
  public A withAdvertisedPort(Integer advertisedPort) {
    this.advertisedPort=advertisedPort; return (A) this;
  }
  public boolean hasAdvertisedPort() {
    return this.advertisedPort != null;
  }
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public boolean hasHost() {
    return this.host != null;
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public boolean hasLabels() {
    return this.labels != null;
  }
  public Integer getNodePort() {
    return this.nodePort;
  }
  public A withNodePort(Integer nodePort) {
    this.nodePort=nodePort; return (A) this;
  }
  public boolean hasNodePort() {
    return this.nodePort != null;
  }
  public String getLoadBalancerIP() {
    return this.loadBalancerIP;
  }
  public A withLoadBalancerIP(String loadBalancerIP) {
    this.loadBalancerIP=loadBalancerIP; return (A) this;
  }
  public boolean hasLoadBalancerIP() {
    return this.loadBalancerIP != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GenericKafkaListenerConfigurationBrokerFluent that = (GenericKafkaListenerConfigurationBrokerFluent) o;
    if (!java.util.Objects.equals(broker, that.broker)) return false;

    if (!java.util.Objects.equals(advertisedHost, that.advertisedHost)) return false;

    if (!java.util.Objects.equals(advertisedPort, that.advertisedPort)) return false;

    if (!java.util.Objects.equals(host, that.host)) return false;

    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(labels, that.labels)) return false;

    if (!java.util.Objects.equals(nodePort, that.nodePort)) return false;

    if (!java.util.Objects.equals(loadBalancerIP, that.loadBalancerIP)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(broker,  advertisedHost,  advertisedPort,  host,  annotations,  labels,  nodePort,  loadBalancerIP,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (broker != null) { sb.append("broker:"); sb.append(broker + ","); }
    if (advertisedHost != null) { sb.append("advertisedHost:"); sb.append(advertisedHost + ","); }
    if (advertisedPort != null) { sb.append("advertisedPort:"); sb.append(advertisedPort + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (nodePort != null) { sb.append("nodePort:"); sb.append(nodePort + ","); }
    if (loadBalancerIP != null) { sb.append("loadBalancerIP:"); sb.append(loadBalancerIP); }
    sb.append("}");
    return sb.toString();
  }
  
}