package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GenericKafkaListenerConfigurationBuilder extends GenericKafkaListenerConfigurationFluent<GenericKafkaListenerConfigurationBuilder> implements VisitableBuilder<GenericKafkaListenerConfiguration,GenericKafkaListenerConfigurationBuilder>{
  public GenericKafkaListenerConfigurationBuilder() {
    this(false);
  }
  public GenericKafkaListenerConfigurationBuilder(Boolean validationEnabled) {
    this(new GenericKafkaListenerConfiguration(), validationEnabled);
  }
  public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GenericKafkaListenerConfiguration(), validationEnabled);
  }
  public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfigurationFluent<?> fluent,GenericKafkaListenerConfiguration instance) {
    this(fluent, instance, false);
  }
  public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfigurationFluent<?> fluent,GenericKafkaListenerConfiguration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GenericKafkaListenerConfiguration());

    if (instance != null) {
      fluent.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
      fluent.withControllerClass(instance.getControllerClass());
      fluent.withPreferredNodePortAddressType(instance.getPreferredNodePortAddressType());
      fluent.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
      fluent.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
      fluent.withFinalizers(instance.getFinalizers());
      fluent.withUseServiceDnsDomain(instance.getUseServiceDnsDomain());
      fluent.withBootstrap(instance.getBootstrap());
      fluent.withBrokers(instance.getBrokers());
      fluent.withMaxConnections(instance.getMaxConnections());
      fluent.withMaxConnectionCreationRate(instance.getMaxConnectionCreationRate());
      fluent.withIpFamilyPolicy(instance.getIpFamilyPolicy());
      fluent.withIpFamilies(instance.getIpFamilies());
      fluent.withCreateBootstrapService(instance.getCreateBootstrapService());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfiguration instance) {
    this(instance,false);
  }
  public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfiguration instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GenericKafkaListenerConfiguration());

    if (instance != null) {
      this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
      this.withControllerClass(instance.getControllerClass());
      this.withPreferredNodePortAddressType(instance.getPreferredNodePortAddressType());
      this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
      this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
      this.withFinalizers(instance.getFinalizers());
      this.withUseServiceDnsDomain(instance.getUseServiceDnsDomain());
      this.withBootstrap(instance.getBootstrap());
      this.withBrokers(instance.getBrokers());
      this.withMaxConnections(instance.getMaxConnections());
      this.withMaxConnectionCreationRate(instance.getMaxConnectionCreationRate());
      this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
      this.withIpFamilies(instance.getIpFamilies());
      this.withCreateBootstrapService(instance.getCreateBootstrapService());
    }
    this.validationEnabled = validationEnabled; 
  }
  GenericKafkaListenerConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public GenericKafkaListenerConfiguration build() {
    GenericKafkaListenerConfiguration buildable = new GenericKafkaListenerConfiguration();
    buildable.setBrokerCertChainAndKey(fluent.buildBrokerCertChainAndKey());
    buildable.setControllerClass(fluent.getControllerClass());
    buildable.setPreferredNodePortAddressType(fluent.getPreferredNodePortAddressType());
    buildable.setExternalTrafficPolicy(fluent.getExternalTrafficPolicy());
    buildable.setLoadBalancerSourceRanges(fluent.getLoadBalancerSourceRanges());
    buildable.setFinalizers(fluent.getFinalizers());
    buildable.setUseServiceDnsDomain(fluent.getUseServiceDnsDomain());
    buildable.setBootstrap(fluent.buildBootstrap());
    buildable.setBrokers(fluent.buildBrokers());
    buildable.setMaxConnections(fluent.getMaxConnections());
    buildable.setMaxConnectionCreationRate(fluent.getMaxConnectionCreationRate());
    buildable.setIpFamilyPolicy(fluent.getIpFamilyPolicy());
    buildable.setIpFamilies(fluent.getIpFamilies());
    buildable.setCreateBootstrapService(fluent.getCreateBootstrapService());
    return buildable;
  }
  
}