package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaNodePoolSpecBuilder extends KafkaNodePoolSpecFluent<KafkaNodePoolSpecBuilder> implements VisitableBuilder<KafkaNodePoolSpec,KafkaNodePoolSpecBuilder>{
  public KafkaNodePoolSpecBuilder() {
    this(false);
  }
  public KafkaNodePoolSpecBuilder(Boolean validationEnabled) {
    this(new KafkaNodePoolSpec(), validationEnabled);
  }
  public KafkaNodePoolSpecBuilder(KafkaNodePoolSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaNodePoolSpecBuilder(KafkaNodePoolSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaNodePoolSpec(), validationEnabled);
  }
  public KafkaNodePoolSpecBuilder(KafkaNodePoolSpecFluent<?> fluent,KafkaNodePoolSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaNodePoolSpecBuilder(KafkaNodePoolSpecFluent<?> fluent,KafkaNodePoolSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaNodePoolSpec());

    if (instance != null) {
      fluent.withReplicas(instance.getReplicas());
      fluent.withStorage(instance.getStorage());
      fluent.withRoles(instance.getRoles());
      fluent.withResources(instance.getResources());
      fluent.withJvmOptions(instance.getJvmOptions());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaNodePoolSpecBuilder(KafkaNodePoolSpec instance) {
    this(instance,false);
  }
  public KafkaNodePoolSpecBuilder(KafkaNodePoolSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaNodePoolSpec());

    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withStorage(instance.getStorage());
      this.withRoles(instance.getRoles());
      this.withResources(instance.getResources());
      this.withJvmOptions(instance.getJvmOptions());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaNodePoolSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaNodePoolSpec build() {
    KafkaNodePoolSpec buildable = new KafkaNodePoolSpec();
    buildable.setReplicas(fluent.getReplicas());
    buildable.setStorage(fluent.buildStorage());
    buildable.setRoles(fluent.getRoles());
    buildable.setResources(fluent.getResources());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  
}