package io.strimzi.api.kafka.model.nodepool;

import io.strimzi.api.kafka.model.JvmOptionsFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.JvmOptionsBuilder;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.JbodStorageFluent;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.storage.JbodStorageBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import java.util.List;
import io.strimzi.api.kafka.model.SpecFluent;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluent;
import io.strimzi.api.kafka.model.storage.Storage;
import io.strimzi.api.kafka.model.JvmOptions;
import java.util.Collection;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import java.lang.Object;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaNodePoolSpecFluent<A extends KafkaNodePoolSpecFluent<A>> extends SpecFluent<A>{
  public KafkaNodePoolSpecFluent() {
  }
  public KafkaNodePoolSpecFluent(KafkaNodePoolSpec instance) {
    instance = (instance != null ? instance : new KafkaNodePoolSpec());

    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withStorage(instance.getStorage());
      this.withRoles(instance.getRoles());
      this.withResources(instance.getResources());
      this.withJvmOptions(instance.getJvmOptions());
      this.withTemplate(instance.getTemplate());
    }
  }
  private int replicas;
  private VisitableBuilder<? extends Storage,?> storage;
  private List<ProcessRoles> roles;
  private ResourceRequirements resources;
  private JvmOptionsBuilder jvmOptions;
  private KafkaNodePoolTemplateBuilder template;
  public int getReplicas() {
    return this.replicas;
  }
  public A withReplicas(int replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return true;
  }
  public Storage buildStorage() {
    return this.storage!=null?this.storage.build():null;
  }
  public A withStorage(Storage storage) {
    if (storage==null){ this.storage = null; _visitables.remove("storage"); return (A) this;}
    VisitableBuilder<? extends Storage,?> builder = builder(storage); _visitables.get("storage").clear();_visitables.get("storage").add(builder);this.storage = builder;
    return (A) this;
  }
  public boolean hasStorage() {
    return this.storage != null;
  }
  public PersistentClaimStorageNested<A> withNewPersistentClaimStorage() {
    return new PersistentClaimStorageNested(null);
  }
  public PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(PersistentClaimStorage item) {
    return new PersistentClaimStorageNested(item);
  }
  public EphemeralStorageNested<A> withNewEphemeralStorage() {
    return new EphemeralStorageNested(null);
  }
  public EphemeralStorageNested<A> withNewEphemeralStorageLike(EphemeralStorage item) {
    return new EphemeralStorageNested(item);
  }
  public JbodStorageNested<A> withNewJbodStorage() {
    return new JbodStorageNested(null);
  }
  public JbodStorageNested<A> withNewJbodStorageLike(JbodStorage item) {
    return new JbodStorageNested(item);
  }
  public A addToRoles(int index,ProcessRoles item) {
    if (this.roles == null) {this.roles = new ArrayList<ProcessRoles>();}
    this.roles.add(index, item);
    return (A)this;
  }
  public A setToRoles(int index,ProcessRoles item) {
    if (this.roles == null) {this.roles = new ArrayList<ProcessRoles>();}
    this.roles.set(index, item); return (A)this;
  }
  public A addToRoles(io.strimzi.api.kafka.model.nodepool.ProcessRoles... items) {
    if (this.roles == null) {this.roles = new ArrayList<ProcessRoles>();}
    for (ProcessRoles item : items) {this.roles.add(item);} return (A)this;
  }
  public A addAllToRoles(Collection<ProcessRoles> items) {
    if (this.roles == null) {this.roles = new ArrayList<ProcessRoles>();}
    for (ProcessRoles item : items) {this.roles.add(item);} return (A)this;
  }
  public A removeFromRoles(io.strimzi.api.kafka.model.nodepool.ProcessRoles... items) {
    if (this.roles == null) return (A)this;
    for (ProcessRoles item : items) { this.roles.remove(item);} return (A)this;
  }
  public A removeAllFromRoles(Collection<ProcessRoles> items) {
    if (this.roles == null) return (A)this;
    for (ProcessRoles item : items) { this.roles.remove(item);} return (A)this;
  }
  public List<ProcessRoles> getRoles() {
    return this.roles;
  }
  public ProcessRoles getRole(int index) {
    return this.roles.get(index);
  }
  public ProcessRoles getFirstRole() {
    return this.roles.get(0);
  }
  public ProcessRoles getLastRole() {
    return this.roles.get(roles.size() - 1);
  }
  public ProcessRoles getMatchingRole(Predicate<ProcessRoles> predicate) {
    for (ProcessRoles item: roles) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingRole(Predicate<ProcessRoles> predicate) {
    for (ProcessRoles item: roles) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoles(List<ProcessRoles> roles) {
    if (roles != null) {this.roles = new ArrayList(); for (ProcessRoles item : roles){this.addToRoles(item);}} else { this.roles = null;} return (A) this;
  }
  public A withRoles(io.strimzi.api.kafka.model.nodepool.ProcessRoles... roles) {
    if (this.roles != null) {this.roles.clear(); _visitables.remove("roles"); }
    if (roles != null) {for (ProcessRoles item :roles){ this.addToRoles(item);}} return (A) this;
  }
  public boolean hasRoles() {
    return roles != null && !roles.isEmpty();
  }
  public ResourceRequirements getResources() {
    return this.resources;
  }
  public A withResources(ResourceRequirements resources) {
    this.resources=resources; return (A) this;
  }
  public boolean hasResources() {
    return this.resources != null;
  }
  public JvmOptions buildJvmOptions() {
    return this.jvmOptions!=null ?this.jvmOptions.build():null;
  }
  public A withJvmOptions(JvmOptions jvmOptions) {
    _visitables.get("jvmOptions").remove(this.jvmOptions);
    if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} else { this.jvmOptions = null; _visitables.get("jvmOptions").remove(this.jvmOptions); } return (A) this;
  }
  public boolean hasJvmOptions() {
    return this.jvmOptions != null;
  }
  public JvmOptionsNested<A> withNewJvmOptions() {
    return new JvmOptionsNested(null);
  }
  public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
    return new JvmOptionsNested(item);
  }
  public JvmOptionsNested<A> editJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(null));
  }
  public JvmOptionsNested<A> editOrNewJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
  }
  public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(item));
  }
  public KafkaNodePoolTemplate buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(KafkaNodePoolTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new KafkaNodePoolTemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  public TemplateNested<A> withNewTemplateLike(KafkaNodePoolTemplate item) {
    return new TemplateNested(item);
  }
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new KafkaNodePoolTemplateBuilder().build()));
  }
  public TemplateNested<A> editOrNewTemplateLike(KafkaNodePoolTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaNodePoolSpecFluent that = (KafkaNodePoolSpecFluent) o;
    if (replicas != that.replicas) return false;
    if (!java.util.Objects.equals(storage, that.storage)) return false;

    if (!java.util.Objects.equals(roles, that.roles)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(jvmOptions, that.jvmOptions)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(replicas,  storage,  roles,  resources,  jvmOptions,  template,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("replicas:"); sb.append(replicas + ",");
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (roles != null && !roles.isEmpty()) { sb.append("roles:"); sb.append(roles + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (jvmOptions != null) { sb.append("jvmOptions:"); sb.append(jvmOptions + ","); }
    if (template != null) { sb.append("template:"); sb.append(template); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.storage."+"PersistentClaimStorage": return (VisitableBuilder<T, ?>)new PersistentClaimStorageBuilder((PersistentClaimStorage) item);
    case "io.strimzi.api.kafka.model.storage."+"EphemeralStorage": return (VisitableBuilder<T, ?>)new EphemeralStorageBuilder((EphemeralStorage) item);
    case "io.strimzi.api.kafka.model.storage."+"JbodStorage": return (VisitableBuilder<T, ?>)new JbodStorageBuilder((JbodStorage) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class PersistentClaimStorageNested<N> extends PersistentClaimStorageFluent<PersistentClaimStorageNested<N>> implements Nested<N>{
    PersistentClaimStorageNested(PersistentClaimStorage item) {
      this.builder = new PersistentClaimStorageBuilder(this, item);
    }
    PersistentClaimStorageBuilder builder;
    public N and() {
      return (N) KafkaNodePoolSpecFluent.this.withStorage(builder.build());
    }
    public N endPersistentClaimStorage() {
      return and();
    }
    
  }
  public class EphemeralStorageNested<N> extends EphemeralStorageFluent<EphemeralStorageNested<N>> implements Nested<N>{
    EphemeralStorageNested(EphemeralStorage item) {
      this.builder = new EphemeralStorageBuilder(this, item);
    }
    EphemeralStorageBuilder builder;
    public N and() {
      return (N) KafkaNodePoolSpecFluent.this.withStorage(builder.build());
    }
    public N endEphemeralStorage() {
      return and();
    }
    
  }
  public class JbodStorageNested<N> extends JbodStorageFluent<JbodStorageNested<N>> implements Nested<N>{
    JbodStorageNested(JbodStorage item) {
      this.builder = new JbodStorageBuilder(this, item);
    }
    JbodStorageBuilder builder;
    public N and() {
      return (N) KafkaNodePoolSpecFluent.this.withStorage(builder.build());
    }
    public N endJbodStorage() {
      return and();
    }
    
  }
  public class JvmOptionsNested<N> extends JvmOptionsFluent<JvmOptionsNested<N>> implements Nested<N>{
    JvmOptionsNested(JvmOptions item) {
      this.builder = new JvmOptionsBuilder(this, item);
    }
    JvmOptionsBuilder builder;
    public N and() {
      return (N) KafkaNodePoolSpecFluent.this.withJvmOptions(builder.build());
    }
    public N endJvmOptions() {
      return and();
    }
    
  }
  public class TemplateNested<N> extends KafkaNodePoolTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(KafkaNodePoolTemplate item) {
      this.builder = new KafkaNodePoolTemplateBuilder(this, item);
    }
    KafkaNodePoolTemplateBuilder builder;
    public N and() {
      return (N) KafkaNodePoolSpecFluent.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}