package io.strimzi.api.kafka.model.nodepool;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import io.strimzi.api.kafka.model.status.StatusFluent;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaNodePoolStatusFluent<A extends KafkaNodePoolStatusFluent<A>> extends StatusFluent<A>{
  public KafkaNodePoolStatusFluent() {
  }
  public KafkaNodePoolStatusFluent(KafkaNodePoolStatus instance) {
    instance = (instance != null ? instance : new KafkaNodePoolStatus());

    if (instance != null) {
      this.withNodeIds(instance.getNodeIds());
      this.withClusterId(instance.getClusterId());
      this.withRoles(instance.getRoles());
      this.withReplicas(instance.getReplicas());
      this.withLabelSelector(instance.getLabelSelector());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
  }
  private List<Integer> nodeIds;
  private String clusterId;
  private List<ProcessRoles> roles;
  private int replicas;
  private String labelSelector;
  public A addToNodeIds(int index,Integer item) {
    if (this.nodeIds == null) {this.nodeIds = new ArrayList<Integer>();}
    this.nodeIds.add(index, item);
    return (A)this;
  }
  public A setToNodeIds(int index,Integer item) {
    if (this.nodeIds == null) {this.nodeIds = new ArrayList<Integer>();}
    this.nodeIds.set(index, item); return (A)this;
  }
  public A addToNodeIds(java.lang.Integer... items) {
    if (this.nodeIds == null) {this.nodeIds = new ArrayList<Integer>();}
    for (Integer item : items) {this.nodeIds.add(item);} return (A)this;
  }
  public A addAllToNodeIds(Collection<Integer> items) {
    if (this.nodeIds == null) {this.nodeIds = new ArrayList<Integer>();}
    for (Integer item : items) {this.nodeIds.add(item);} return (A)this;
  }
  public A removeFromNodeIds(java.lang.Integer... items) {
    if (this.nodeIds == null) return (A)this;
    for (Integer item : items) { this.nodeIds.remove(item);} return (A)this;
  }
  public A removeAllFromNodeIds(Collection<Integer> items) {
    if (this.nodeIds == null) return (A)this;
    for (Integer item : items) { this.nodeIds.remove(item);} return (A)this;
  }
  public List<Integer> getNodeIds() {
    return this.nodeIds;
  }
  public Integer getNodeId(int index) {
    return this.nodeIds.get(index);
  }
  public Integer getFirstNodeId() {
    return this.nodeIds.get(0);
  }
  public Integer getLastNodeId() {
    return this.nodeIds.get(nodeIds.size() - 1);
  }
  public Integer getMatchingNodeId(Predicate<Integer> predicate) {
    for (Integer item: nodeIds) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingNodeId(Predicate<Integer> predicate) {
    for (Integer item: nodeIds) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNodeIds(List<Integer> nodeIds) {
    if (nodeIds != null) {this.nodeIds = new ArrayList(); for (Integer item : nodeIds){this.addToNodeIds(item);}} else { this.nodeIds = null;} return (A) this;
  }
  public A withNodeIds(java.lang.Integer... nodeIds) {
    if (this.nodeIds != null) {this.nodeIds.clear(); _visitables.remove("nodeIds"); }
    if (nodeIds != null) {for (Integer item :nodeIds){ this.addToNodeIds(item);}} return (A) this;
  }
  public boolean hasNodeIds() {
    return nodeIds != null && !nodeIds.isEmpty();
  }
  public String getClusterId() {
    return this.clusterId;
  }
  public A withClusterId(String clusterId) {
    this.clusterId=clusterId; return (A) this;
  }
  public boolean hasClusterId() {
    return this.clusterId != null;
  }
  public A addToRoles(int index,ProcessRoles item) {
    if (this.roles == null) {this.roles = new ArrayList<ProcessRoles>();}
    this.roles.add(index, item);
    return (A)this;
  }
  public A setToRoles(int index,ProcessRoles item) {
    if (this.roles == null) {this.roles = new ArrayList<ProcessRoles>();}
    this.roles.set(index, item); return (A)this;
  }
  public A addToRoles(io.strimzi.api.kafka.model.nodepool.ProcessRoles... items) {
    if (this.roles == null) {this.roles = new ArrayList<ProcessRoles>();}
    for (ProcessRoles item : items) {this.roles.add(item);} return (A)this;
  }
  public A addAllToRoles(Collection<ProcessRoles> items) {
    if (this.roles == null) {this.roles = new ArrayList<ProcessRoles>();}
    for (ProcessRoles item : items) {this.roles.add(item);} return (A)this;
  }
  public A removeFromRoles(io.strimzi.api.kafka.model.nodepool.ProcessRoles... items) {
    if (this.roles == null) return (A)this;
    for (ProcessRoles item : items) { this.roles.remove(item);} return (A)this;
  }
  public A removeAllFromRoles(Collection<ProcessRoles> items) {
    if (this.roles == null) return (A)this;
    for (ProcessRoles item : items) { this.roles.remove(item);} return (A)this;
  }
  public List<ProcessRoles> getRoles() {
    return this.roles;
  }
  public ProcessRoles getRole(int index) {
    return this.roles.get(index);
  }
  public ProcessRoles getFirstRole() {
    return this.roles.get(0);
  }
  public ProcessRoles getLastRole() {
    return this.roles.get(roles.size() - 1);
  }
  public ProcessRoles getMatchingRole(Predicate<ProcessRoles> predicate) {
    for (ProcessRoles item: roles) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingRole(Predicate<ProcessRoles> predicate) {
    for (ProcessRoles item: roles) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoles(List<ProcessRoles> roles) {
    if (roles != null) {this.roles = new ArrayList(); for (ProcessRoles item : roles){this.addToRoles(item);}} else { this.roles = null;} return (A) this;
  }
  public A withRoles(io.strimzi.api.kafka.model.nodepool.ProcessRoles... roles) {
    if (this.roles != null) {this.roles.clear(); _visitables.remove("roles"); }
    if (roles != null) {for (ProcessRoles item :roles){ this.addToRoles(item);}} return (A) this;
  }
  public boolean hasRoles() {
    return roles != null && !roles.isEmpty();
  }
  public int getReplicas() {
    return this.replicas;
  }
  public A withReplicas(int replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return true;
  }
  public String getLabelSelector() {
    return this.labelSelector;
  }
  public A withLabelSelector(String labelSelector) {
    this.labelSelector=labelSelector; return (A) this;
  }
  public boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaNodePoolStatusFluent that = (KafkaNodePoolStatusFluent) o;
    if (!java.util.Objects.equals(nodeIds, that.nodeIds)) return false;

    if (!java.util.Objects.equals(clusterId, that.clusterId)) return false;

    if (!java.util.Objects.equals(roles, that.roles)) return false;

    if (replicas != that.replicas) return false;
    if (!java.util.Objects.equals(labelSelector, that.labelSelector)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(nodeIds,  clusterId,  roles,  replicas,  labelSelector,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nodeIds != null && !nodeIds.isEmpty()) { sb.append("nodeIds:"); sb.append(nodeIds + ","); }
    if (clusterId != null) { sb.append("clusterId:"); sb.append(clusterId + ","); }
    if (roles != null && !roles.isEmpty()) { sb.append("roles:"); sb.append(roles + ","); }
    sb.append("replicas:"); sb.append(replicas + ",");
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector); }
    sb.append("}");
    return sb.toString();
  }
  
}