package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaNodePoolTemplateBuilder extends KafkaNodePoolTemplateFluent<KafkaNodePoolTemplateBuilder> implements VisitableBuilder<KafkaNodePoolTemplate,KafkaNodePoolTemplateBuilder>{
  public KafkaNodePoolTemplateBuilder() {
    this(false);
  }
  public KafkaNodePoolTemplateBuilder(Boolean validationEnabled) {
    this(new KafkaNodePoolTemplate(), validationEnabled);
  }
  public KafkaNodePoolTemplateBuilder(KafkaNodePoolTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaNodePoolTemplateBuilder(KafkaNodePoolTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaNodePoolTemplate(), validationEnabled);
  }
  public KafkaNodePoolTemplateBuilder(KafkaNodePoolTemplateFluent<?> fluent,KafkaNodePoolTemplate instance) {
    this(fluent, instance, false);
  }
  public KafkaNodePoolTemplateBuilder(KafkaNodePoolTemplateFluent<?> fluent,KafkaNodePoolTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaNodePoolTemplate());

    if (instance != null) {
      fluent.withPodSet(instance.getPodSet());
      fluent.withPod(instance.getPod());
      fluent.withPerPodService(instance.getPerPodService());
      fluent.withPerPodRoute(instance.getPerPodRoute());
      fluent.withPerPodIngress(instance.getPerPodIngress());
      fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      fluent.withKafkaContainer(instance.getKafkaContainer());
      fluent.withInitContainer(instance.getInitContainer());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaNodePoolTemplateBuilder(KafkaNodePoolTemplate instance) {
    this(instance,false);
  }
  public KafkaNodePoolTemplateBuilder(KafkaNodePoolTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaNodePoolTemplate());

    if (instance != null) {
      this.withPodSet(instance.getPodSet());
      this.withPod(instance.getPod());
      this.withPerPodService(instance.getPerPodService());
      this.withPerPodRoute(instance.getPerPodRoute());
      this.withPerPodIngress(instance.getPerPodIngress());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withKafkaContainer(instance.getKafkaContainer());
      this.withInitContainer(instance.getInitContainer());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaNodePoolTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaNodePoolTemplate build() {
    KafkaNodePoolTemplate buildable = new KafkaNodePoolTemplate();
    buildable.setPodSet(fluent.buildPodSet());
    buildable.setPod(fluent.buildPod());
    buildable.setPerPodService(fluent.buildPerPodService());
    buildable.setPerPodRoute(fluent.buildPerPodRoute());
    buildable.setPerPodIngress(fluent.buildPerPodIngress());
    buildable.setPersistentVolumeClaim(fluent.buildPersistentVolumeClaim());
    buildable.setKafkaContainer(fluent.buildKafkaContainer());
    buildable.setInitContainer(fluent.buildInitContainer());
    return buildable;
  }
  
}