package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AutoRestartStatusBuilder extends AutoRestartStatusFluent<AutoRestartStatusBuilder> implements VisitableBuilder<AutoRestartStatus,AutoRestartStatusBuilder>{
  public AutoRestartStatusBuilder() {
    this(false);
  }
  public AutoRestartStatusBuilder(Boolean validationEnabled) {
    this(new AutoRestartStatus(), validationEnabled);
  }
  public AutoRestartStatusBuilder(AutoRestartStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AutoRestartStatusBuilder(AutoRestartStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AutoRestartStatus(), validationEnabled);
  }
  public AutoRestartStatusBuilder(AutoRestartStatusFluent<?> fluent,AutoRestartStatus instance) {
    this(fluent, instance, false);
  }
  public AutoRestartStatusBuilder(AutoRestartStatusFluent<?> fluent,AutoRestartStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AutoRestartStatus());

    if (instance != null) {
      fluent.withCount(instance.getCount());
      fluent.withConnectorName(instance.getConnectorName());
      fluent.withLastRestartTimestamp(instance.getLastRestartTimestamp());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AutoRestartStatusBuilder(AutoRestartStatus instance) {
    this(instance,false);
  }
  public AutoRestartStatusBuilder(AutoRestartStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AutoRestartStatus());

    if (instance != null) {
      this.withCount(instance.getCount());
      this.withConnectorName(instance.getConnectorName());
      this.withLastRestartTimestamp(instance.getLastRestartTimestamp());
    }
    this.validationEnabled = validationEnabled; 
  }
  AutoRestartStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AutoRestartStatus build() {
    AutoRestartStatus buildable = new AutoRestartStatus();
    buildable.setCount(fluent.getCount());
    buildable.setConnectorName(fluent.getConnectorName());
    buildable.setLastRestartTimestamp(fluent.getLastRestartTimestamp());
    return buildable;
  }
  
}