package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConditionBuilder extends ConditionFluent<ConditionBuilder> implements VisitableBuilder<Condition,ConditionBuilder>{
  public ConditionBuilder() {
    this(false);
  }
  public ConditionBuilder(Boolean validationEnabled) {
    this(new Condition(), validationEnabled);
  }
  public ConditionBuilder(ConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ConditionBuilder(ConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Condition(), validationEnabled);
  }
  public ConditionBuilder(ConditionFluent<?> fluent,Condition instance) {
    this(fluent, instance, false);
  }
  public ConditionBuilder(ConditionFluent<?> fluent,Condition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Condition());

    if (instance != null) {
      fluent.withStatus(instance.getStatus());
      fluent.withReason(instance.getReason());
      fluent.withMessage(instance.getMessage());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConditionBuilder(Condition instance) {
    this(instance,false);
  }
  public ConditionBuilder(Condition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Condition());

    if (instance != null) {
      this.withStatus(instance.getStatus());
      this.withReason(instance.getReason());
      this.withMessage(instance.getMessage());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConditionFluent<?> fluent;
  Boolean validationEnabled;
  public Condition build() {
    Condition buildable = new Condition();
    buildable.setStatus(fluent.getStatus());
    buildable.setReason(fluent.getReason());
    buildable.setMessage(fluent.getMessage());
    buildable.setType(fluent.getType());
    buildable.setLastTransitionTime(fluent.getLastTransitionTime());
    return buildable;
  }
  
}