package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBridgeStatusBuilder extends KafkaBridgeStatusFluent<KafkaBridgeStatusBuilder> implements VisitableBuilder<KafkaBridgeStatus,KafkaBridgeStatusBuilder>{
  public KafkaBridgeStatusBuilder() {
    this(false);
  }
  public KafkaBridgeStatusBuilder(Boolean validationEnabled) {
    this(new KafkaBridgeStatus(), validationEnabled);
  }
  public KafkaBridgeStatusBuilder(KafkaBridgeStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBridgeStatusBuilder(KafkaBridgeStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBridgeStatus(), validationEnabled);
  }
  public KafkaBridgeStatusBuilder(KafkaBridgeStatusFluent<?> fluent,KafkaBridgeStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaBridgeStatusBuilder(KafkaBridgeStatusFluent<?> fluent,KafkaBridgeStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaBridgeStatus());

    if (instance != null) {
      fluent.withUrl(instance.getUrl());
      fluent.withReplicas(instance.getReplicas());
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBridgeStatusBuilder(KafkaBridgeStatus instance) {
    this(instance,false);
  }
  public KafkaBridgeStatusBuilder(KafkaBridgeStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaBridgeStatus());

    if (instance != null) {
      this.withUrl(instance.getUrl());
      this.withReplicas(instance.getReplicas());
      this.withLabelSelector(instance.getLabelSelector());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaBridgeStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBridgeStatus build() {
    KafkaBridgeStatus buildable = new KafkaBridgeStatus();
    buildable.setUrl(fluent.getUrl());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setLabelSelector(fluent.getLabelSelector());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  
}