package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaConnectorStatusBuilder extends KafkaConnectorStatusFluent<KafkaConnectorStatusBuilder> implements VisitableBuilder<KafkaConnectorStatus,KafkaConnectorStatusBuilder>{
  public KafkaConnectorStatusBuilder() {
    this(false);
  }
  public KafkaConnectorStatusBuilder(Boolean validationEnabled) {
    this(new KafkaConnectorStatus(), validationEnabled);
  }
  public KafkaConnectorStatusBuilder(KafkaConnectorStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaConnectorStatusBuilder(KafkaConnectorStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaConnectorStatus(), validationEnabled);
  }
  public KafkaConnectorStatusBuilder(KafkaConnectorStatusFluent<?> fluent,KafkaConnectorStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaConnectorStatusBuilder(KafkaConnectorStatusFluent<?> fluent,KafkaConnectorStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaConnectorStatus());

    if (instance != null) {
      fluent.withConnectorStatus(instance.getConnectorStatus());
      fluent.withTasksMax(instance.getTasksMax());
      fluent.withTopics(instance.getTopics());
      fluent.withAutoRestart(instance.getAutoRestart());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaConnectorStatusBuilder(KafkaConnectorStatus instance) {
    this(instance,false);
  }
  public KafkaConnectorStatusBuilder(KafkaConnectorStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaConnectorStatus());

    if (instance != null) {
      this.withConnectorStatus(instance.getConnectorStatus());
      this.withTasksMax(instance.getTasksMax());
      this.withTopics(instance.getTopics());
      this.withAutoRestart(instance.getAutoRestart());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaConnectorStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaConnectorStatus build() {
    KafkaConnectorStatus buildable = new KafkaConnectorStatus();
    buildable.setConnectorStatus(fluent.getConnectorStatus());
    buildable.setTasksMax(fluent.getTasksMax());
    buildable.setTopics(fluent.getTopics());
    buildable.setAutoRestart(fluent.buildAutoRestart());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  
}