package io.strimzi.api.kafka.model.status;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaConnectorStatusFluent<A extends KafkaConnectorStatusFluent<A>> extends StatusFluent<A>{
  public KafkaConnectorStatusFluent() {
  }
  public KafkaConnectorStatusFluent(KafkaConnectorStatus instance) {
    instance = (instance != null ? instance : new KafkaConnectorStatus());

    if (instance != null) {
      this.withConnectorStatus(instance.getConnectorStatus());
      this.withTasksMax(instance.getTasksMax());
      this.withTopics(instance.getTopics());
      this.withAutoRestart(instance.getAutoRestart());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
  }
  private Map<String,Object> connectorStatus;
  private int tasksMax;
  private List<String> topics;
  private AutoRestartStatusBuilder autoRestart;
  public A addToConnectorStatus(String key,Object value) {
    if(this.connectorStatus == null && key != null && value != null) { this.connectorStatus = new LinkedHashMap(); }
    if(key != null && value != null) {this.connectorStatus.put(key, value);} return (A)this;
  }
  public A addToConnectorStatus(Map<String,Object> map) {
    if(this.connectorStatus == null && map != null) { this.connectorStatus = new LinkedHashMap(); }
    if(map != null) { this.connectorStatus.putAll(map);} return (A)this;
  }
  public A removeFromConnectorStatus(String key) {
    if(this.connectorStatus == null) { return (A) this; }
    if(key != null && this.connectorStatus != null) {this.connectorStatus.remove(key);} return (A)this;
  }
  public A removeFromConnectorStatus(Map<String,Object> map) {
    if(this.connectorStatus == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.connectorStatus != null){this.connectorStatus.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getConnectorStatus() {
    return this.connectorStatus;
  }
  public <K,V>A withConnectorStatus(Map<String,Object> connectorStatus) {
    if (connectorStatus == null) { this.connectorStatus =  null;} else {this.connectorStatus = new LinkedHashMap(connectorStatus);} return (A) this;
  }
  public boolean hasConnectorStatus() {
    return this.connectorStatus != null;
  }
  public int getTasksMax() {
    return this.tasksMax;
  }
  public A withTasksMax(int tasksMax) {
    this.tasksMax=tasksMax; return (A) this;
  }
  public boolean hasTasksMax() {
    return true;
  }
  public A addToTopics(int index,String item) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    this.topics.add(index, item);
    return (A)this;
  }
  public A setToTopics(int index,String item) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    this.topics.set(index, item); return (A)this;
  }
  public A addToTopics(java.lang.String... items) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    for (String item : items) {this.topics.add(item);} return (A)this;
  }
  public A addAllToTopics(Collection<String> items) {
    if (this.topics == null) {this.topics = new ArrayList<String>();}
    for (String item : items) {this.topics.add(item);} return (A)this;
  }
  public A removeFromTopics(java.lang.String... items) {
    if (this.topics == null) return (A)this;
    for (String item : items) { this.topics.remove(item);} return (A)this;
  }
  public A removeAllFromTopics(Collection<String> items) {
    if (this.topics == null) return (A)this;
    for (String item : items) { this.topics.remove(item);} return (A)this;
  }
  public List<String> getTopics() {
    return this.topics;
  }
  public String getTopic(int index) {
    return this.topics.get(index);
  }
  public String getFirstTopic() {
    return this.topics.get(0);
  }
  public String getLastTopic() {
    return this.topics.get(topics.size() - 1);
  }
  public String getMatchingTopic(Predicate<String> predicate) {
    for (String item: topics) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingTopic(Predicate<String> predicate) {
    for (String item: topics) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopics(List<String> topics) {
    if (topics != null) {this.topics = new ArrayList(); for (String item : topics){this.addToTopics(item);}} else { this.topics = null;} return (A) this;
  }
  public A withTopics(java.lang.String... topics) {
    if (this.topics != null) {this.topics.clear(); _visitables.remove("topics"); }
    if (topics != null) {for (String item :topics){ this.addToTopics(item);}} return (A) this;
  }
  public boolean hasTopics() {
    return topics != null && !topics.isEmpty();
  }
  public AutoRestartStatus buildAutoRestart() {
    return this.autoRestart!=null ?this.autoRestart.build():null;
  }
  public A withAutoRestart(AutoRestartStatus autoRestart) {
    _visitables.get("autoRestart").remove(this.autoRestart);
    if (autoRestart!=null){ this.autoRestart= new AutoRestartStatusBuilder(autoRestart); _visitables.get("autoRestart").add(this.autoRestart);} else { this.autoRestart = null; _visitables.get("autoRestart").remove(this.autoRestart); } return (A) this;
  }
  public boolean hasAutoRestart() {
    return this.autoRestart != null;
  }
  public AutoRestartNested<A> withNewAutoRestart() {
    return new AutoRestartNested(null);
  }
  public AutoRestartNested<A> withNewAutoRestartLike(AutoRestartStatus item) {
    return new AutoRestartNested(item);
  }
  public AutoRestartNested<A> editAutoRestart() {
    return withNewAutoRestartLike(java.util.Optional.ofNullable(buildAutoRestart()).orElse(null));
  }
  public AutoRestartNested<A> editOrNewAutoRestart() {
    return withNewAutoRestartLike(java.util.Optional.ofNullable(buildAutoRestart()).orElse(new AutoRestartStatusBuilder().build()));
  }
  public AutoRestartNested<A> editOrNewAutoRestartLike(AutoRestartStatus item) {
    return withNewAutoRestartLike(java.util.Optional.ofNullable(buildAutoRestart()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaConnectorStatusFluent that = (KafkaConnectorStatusFluent) o;
    if (!java.util.Objects.equals(connectorStatus, that.connectorStatus)) return false;

    if (tasksMax != that.tasksMax) return false;
    if (!java.util.Objects.equals(topics, that.topics)) return false;

    if (!java.util.Objects.equals(autoRestart, that.autoRestart)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(connectorStatus,  tasksMax,  topics,  autoRestart,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectorStatus != null && !connectorStatus.isEmpty()) { sb.append("connectorStatus:"); sb.append(connectorStatus + ","); }
    sb.append("tasksMax:"); sb.append(tasksMax + ",");
    if (topics != null && !topics.isEmpty()) { sb.append("topics:"); sb.append(topics + ","); }
    if (autoRestart != null) { sb.append("autoRestart:"); sb.append(autoRestart); }
    sb.append("}");
    return sb.toString();
  }
  public class AutoRestartNested<N> extends AutoRestartStatusFluent<AutoRestartNested<N>> implements Nested<N>{
    AutoRestartNested(AutoRestartStatus item) {
      this.builder = new AutoRestartStatusBuilder(this, item);
    }
    AutoRestartStatusBuilder builder;
    public N and() {
      return (N) KafkaConnectorStatusFluent.this.withAutoRestart(builder.build());
    }
    public N endAutoRestart() {
      return and();
    }
    
  }
  
}