package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaMirrorMakerStatusBuilder extends KafkaMirrorMakerStatusFluent<KafkaMirrorMakerStatusBuilder> implements VisitableBuilder<KafkaMirrorMakerStatus,KafkaMirrorMakerStatusBuilder>{
  public KafkaMirrorMakerStatusBuilder() {
    this(false);
  }
  public KafkaMirrorMakerStatusBuilder(Boolean validationEnabled) {
    this(new KafkaMirrorMakerStatus(), validationEnabled);
  }
  public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaMirrorMakerStatus(), validationEnabled);
  }
  public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatusFluent<?> fluent,KafkaMirrorMakerStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatusFluent<?> fluent,KafkaMirrorMakerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaMirrorMakerStatus());

    if (instance != null) {
      fluent.withReplicas(instance.getReplicas());
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatus instance) {
    this(instance,false);
  }
  public KafkaMirrorMakerStatusBuilder(KafkaMirrorMakerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaMirrorMakerStatus());

    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withLabelSelector(instance.getLabelSelector());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaMirrorMakerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaMirrorMakerStatus build() {
    KafkaMirrorMakerStatus buildable = new KafkaMirrorMakerStatus();
    buildable.setReplicas(fluent.getReplicas());
    buildable.setLabelSelector(fluent.getLabelSelector());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  
}