package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaTopicStatusBuilder extends KafkaTopicStatusFluent<KafkaTopicStatusBuilder> implements VisitableBuilder<KafkaTopicStatus,KafkaTopicStatusBuilder>{
  public KafkaTopicStatusBuilder() {
    this(false);
  }
  public KafkaTopicStatusBuilder(Boolean validationEnabled) {
    this(new KafkaTopicStatus(), validationEnabled);
  }
  public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaTopicStatus(), validationEnabled);
  }
  public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent,KafkaTopicStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent,KafkaTopicStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaTopicStatus());

    if (instance != null) {
      fluent.withTopicName(instance.getTopicName());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaTopicStatusBuilder(KafkaTopicStatus instance) {
    this(instance,false);
  }
  public KafkaTopicStatusBuilder(KafkaTopicStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaTopicStatus());

    if (instance != null) {
      this.withTopicName(instance.getTopicName());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaTopicStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaTopicStatus build() {
    KafkaTopicStatus buildable = new KafkaTopicStatus();
    buildable.setTopicName(fluent.getTopicName());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  
}