package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ListenerAddressBuilder extends ListenerAddressFluent<ListenerAddressBuilder> implements VisitableBuilder<ListenerAddress,ListenerAddressBuilder>{
  public ListenerAddressBuilder() {
    this(false);
  }
  public ListenerAddressBuilder(Boolean validationEnabled) {
    this(new ListenerAddress(), validationEnabled);
  }
  public ListenerAddressBuilder(ListenerAddressFluent<?> fluent) {
    this(fluent, false);
  }
  public ListenerAddressBuilder(ListenerAddressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ListenerAddress(), validationEnabled);
  }
  public ListenerAddressBuilder(ListenerAddressFluent<?> fluent,ListenerAddress instance) {
    this(fluent, instance, false);
  }
  public ListenerAddressBuilder(ListenerAddressFluent<?> fluent,ListenerAddress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ListenerAddress());

    if (instance != null) {
      fluent.withHost(instance.getHost());
      fluent.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ListenerAddressBuilder(ListenerAddress instance) {
    this(instance,false);
  }
  public ListenerAddressBuilder(ListenerAddress instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ListenerAddress());

    if (instance != null) {
      this.withHost(instance.getHost());
      this.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  ListenerAddressFluent<?> fluent;
  Boolean validationEnabled;
  public ListenerAddress build() {
    ListenerAddress buildable = new ListenerAddress();
    buildable.setHost(fluent.getHost());
    buildable.setPort(fluent.getPort());
    return buildable;
  }
  
}