package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StrimziPodSetStatusBuilder extends StrimziPodSetStatusFluent<StrimziPodSetStatusBuilder> implements VisitableBuilder<StrimziPodSetStatus,StrimziPodSetStatusBuilder>{
  public StrimziPodSetStatusBuilder() {
    this(false);
  }
  public StrimziPodSetStatusBuilder(Boolean validationEnabled) {
    this(new StrimziPodSetStatus(), validationEnabled);
  }
  public StrimziPodSetStatusBuilder(StrimziPodSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StrimziPodSetStatusBuilder(StrimziPodSetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StrimziPodSetStatus(), validationEnabled);
  }
  public StrimziPodSetStatusBuilder(StrimziPodSetStatusFluent<?> fluent,StrimziPodSetStatus instance) {
    this(fluent, instance, false);
  }
  public StrimziPodSetStatusBuilder(StrimziPodSetStatusFluent<?> fluent,StrimziPodSetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StrimziPodSetStatus());

    if (instance != null) {
      fluent.withPods(instance.getPods());
      fluent.withReadyPods(instance.getReadyPods());
      fluent.withCurrentPods(instance.getCurrentPods());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StrimziPodSetStatusBuilder(StrimziPodSetStatus instance) {
    this(instance,false);
  }
  public StrimziPodSetStatusBuilder(StrimziPodSetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StrimziPodSetStatus());

    if (instance != null) {
      this.withPods(instance.getPods());
      this.withReadyPods(instance.getReadyPods());
      this.withCurrentPods(instance.getCurrentPods());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  StrimziPodSetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public StrimziPodSetStatus build() {
    StrimziPodSetStatus buildable = new StrimziPodSetStatus();
    buildable.setPods(fluent.getPods());
    buildable.setReadyPods(fluent.getReadyPods());
    buildable.setCurrentPods(fluent.getCurrentPods());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  
}