package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EphemeralStorageBuilder extends EphemeralStorageFluent<EphemeralStorageBuilder> implements VisitableBuilder<EphemeralStorage,EphemeralStorageBuilder>{
  public EphemeralStorageBuilder() {
    this(false);
  }
  public EphemeralStorageBuilder(Boolean validationEnabled) {
    this(new EphemeralStorage(), validationEnabled);
  }
  public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent) {
    this(fluent, false);
  }
  public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EphemeralStorage(), validationEnabled);
  }
  public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent,EphemeralStorage instance) {
    this(fluent, instance, false);
  }
  public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent,EphemeralStorage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EphemeralStorage());

    if (instance != null) {
      fluent.withId(instance.getId());
      fluent.withSizeLimit(instance.getSizeLimit());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EphemeralStorageBuilder(EphemeralStorage instance) {
    this(instance,false);
  }
  public EphemeralStorageBuilder(EphemeralStorage instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EphemeralStorage());

    if (instance != null) {
      this.withId(instance.getId());
      this.withSizeLimit(instance.getSizeLimit());
    }
    this.validationEnabled = validationEnabled; 
  }
  EphemeralStorageFluent<?> fluent;
  Boolean validationEnabled;
  public EphemeralStorage build() {
    EphemeralStorage buildable = new EphemeralStorage();
    buildable.setId(fluent.getId());
    buildable.setSizeLimit(fluent.getSizeLimit());
    return buildable;
  }
  
}